/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.message.local.service.internal;

import com.biz.crm.common.message.sdk.dto.SysMessageDto;
import com.biz.crm.common.message.sdk.register.SystemMessageRegister;
import com.biz.crm.common.message.sdk.service.SendMessageVoService;
import com.biz.crm.common.message.sdk.service.SystemMessageTypeService;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SendMessageVoServiceImpl
implements SendMessageVoService {
    private static final Logger log = LoggerFactory.getLogger(SendMessageVoServiceImpl.class);
    @Autowired(required=false)
    private SystemMessageTypeService systemMessageTypeService;

    @Transactional
    public void send(SysMessageDto dto) {
        SystemMessageRegister register = this.systemMessageTypeService.findByCode(dto.getCode());
        Validate.notNull((Object)register, (String)"\u7cfb\u7edf\u6d88\u606f\u5bf9\u5e94\u7684\u6ce8\u518c\u5668\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        register.sendMessage(dto.getMap());
    }

    @Transactional
    public void batchSend(List<SysMessageDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (SysMessageDto item : list) {
            this.send(item);
        }
    }
}

