/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.message.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.message.local.entity.SystemMessage;
import com.biz.crm.common.message.local.repository.SystemMessageRepository;
import com.biz.crm.common.message.local.service.SystemMessageService;
import com.biz.crm.common.message.sdk.dto.SystemMessagePaginationDto;
import com.biz.crm.common.message.sdk.register.SystemMessageRegister;
import com.biz.crm.common.message.sdk.service.SystemMessageTypeService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SystemMessageServiceImpl
implements SystemMessageService {
    private static final Logger log = LoggerFactory.getLogger(SystemMessageServiceImpl.class);
    @Autowired(required=false)
    private SystemMessageRepository systemMessageRepository;
    @Autowired(required=false)
    private SystemMessageTypeService systemMessageTypeService;

    @Override
    public Page<SystemMessage> findByConditions(Pageable pageable, SystemMessagePaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new SystemMessagePaginationDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<SystemMessage> result = this.systemMessageRepository.findByConditions((Page<SystemMessage>)page, dto);
        if (Objects.nonNull(result) && !CollectionUtils.isEmpty((Collection)result.getRecords())) {
            for (SystemMessage item : result.getRecords()) {
                SystemMessageRegister register = this.systemMessageTypeService.findByCode(item.getMessageCode());
                if (Objects.isNull(register)) continue;
                item.setMessageName(register.getName());
            }
        }
        return result;
    }

    @Override
    @Transactional
    public void read(List<String> ids) {
        List<SystemMessage> list = this.systemMessageRepository.findByIds(ids);
        Validate.isTrue((!CollectionUtils.isEmpty(list) ? 1 : 0) != 0, (String)"\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u6d88\u606f\uff01", (Object[])new Object[0]);
        List messages = list.stream().filter(a -> Boolean.FALSE.equals(a.getReadFlag())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(messages)) {
            return;
        }
        for (SystemMessage item : messages) {
            item.setReadFlag(Boolean.TRUE);
        }
        this.systemMessageRepository.saveOrUpdateBatch(messages);
    }

    @Override
    @Transactional
    public void createBatch(List<SystemMessage> data) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        this.systemMessageRepository.saveBatch(data);
    }
}

