/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.message.local.service.internal;

import com.biz.crm.common.message.sdk.dto.SystemMessageTypeQueryDto;
import com.biz.crm.common.message.sdk.register.SystemMessageHandlerRegister;
import com.biz.crm.common.message.sdk.register.SystemMessageRegister;
import com.biz.crm.common.message.sdk.service.SystemMessageTypeService;
import com.biz.crm.common.message.sdk.vo.SystemMessageTypeItemVo;
import com.biz.crm.common.message.sdk.vo.SystemMessageTypeVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SystemMessageTypeServiceImpl
implements SystemMessageTypeService {
    private static final Logger log = LoggerFactory.getLogger(SystemMessageTypeServiceImpl.class);
    @Autowired(required=false)
    private List<SystemMessageRegister> registers;
    @Autowired(required=false)
    private List<SystemMessageHandlerRegister> handlerRegisters;

    public List<SystemMessageTypeVo> findBySystemMessageTypeQueryDto(SystemMessageTypeQueryDto dto) {
        if (CollectionUtils.isEmpty(this.registers)) {
            return Lists.newLinkedList();
        }
        ArrayList list = Lists.newArrayList();
        for (SystemMessageRegister register : this.registers) {
            SystemMessageTypeVo cur = this.findByRegister(register);
            if (!Objects.nonNull(cur)) continue;
            list.add(cur);
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newLinkedList();
        }
        dto.setDesc(Optional.ofNullable(dto.getDesc()).orElse(""));
        dto.setItemName(Optional.ofNullable(dto.getItemName()).orElse(""));
        dto.setName(Optional.ofNullable(dto.getName()).orElse(""));
        dto.setNoticeDesc(Optional.ofNullable(dto.getNoticeDesc()).orElse(""));
        return list.stream().filter(a -> a.getName().contains(dto.getName())).filter(a -> a.getDesc().contains(dto.getDesc())).filter(a -> a.getNoticeDesc().contains(dto.getNoticeDesc())).filter(a -> a.getItemName().contains(dto.getItemName())).sorted(Comparator.comparing(SystemMessageTypeVo::getOrder)).collect(Collectors.toList());
    }

    public SystemMessageRegister findByCode(String code) {
        if (CollectionUtils.isEmpty(this.registers)) {
            return null;
        }
        return this.registers.stream().filter(a -> a.getCode().equals(code)).findFirst().orElse(null);
    }

    public List<SystemMessageHandlerRegister> findHandlerByCodes(Set<String> codes) {
        if (CollectionUtils.isEmpty(this.handlerRegisters) || CollectionUtils.isEmpty(codes)) {
            return Lists.newLinkedList();
        }
        return this.handlerRegisters.stream().filter(a -> codes.contains(a.getCode())).sorted(Comparator.comparing(SystemMessageHandlerRegister::getOrder)).collect(Collectors.toList());
    }

    private SystemMessageTypeVo findByRegister(SystemMessageRegister register) {
        if (Objects.isNull(register)) {
            return null;
        }
        SystemMessageTypeVo vo = new SystemMessageTypeVo();
        vo.setCode(register.getCode());
        vo.setName(register.getName());
        vo.setDesc(register.getDesc());
        vo.setOrder(Integer.valueOf(register.getOrder()));
        if (!CollectionUtils.isEmpty((Collection)register.getHandlerRegisterList())) {
            ArrayList list = Lists.newArrayList();
            for (SystemMessageHandlerRegister item : register.getHandlerRegisterList()) {
                SystemMessageTypeItemVo cur = new SystemMessageTypeItemVo();
                cur.setCode(item.getCode());
                cur.setName(item.getName());
                cur.setNoticeDesc(item.getNoticeDesc());
                cur.setContent(item.getContent());
                cur.setOrder(Integer.valueOf(item.getOrder()));
                list.add(cur);
            }
            vo.setItems(list.stream().sorted(Comparator.comparing(SystemMessageTypeItemVo::getOrder)).collect(Collectors.toList()));
            vo.setItemName(vo.getItems().stream().map(SystemMessageTypeItemVo::getName).collect(Collectors.joining(",")));
            vo.setNoticeDesc(vo.getItems().stream().map(SystemMessageTypeItemVo::getNoticeDesc).collect(Collectors.joining(",")));
        }
        return vo;
    }
}

