/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.message.local.service.internal;

import com.biz.crm.common.message.local.entity.SystemMessage;
import com.biz.crm.common.message.local.service.SystemMessageService;
import com.biz.crm.common.message.sdk.dto.SysMessageItemDto;
import com.biz.crm.common.message.sdk.service.SystemMessageVoService;
import com.biz.crm.common.message.sdk.util.ContentHolderUtil;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SystemMessageVoServiceImpl
implements SystemMessageVoService {
    private static final Logger log = LoggerFactory.getLogger(SystemMessageVoServiceImpl.class);
    @Autowired
    private SystemMessageService systemMessageService;

    @Transactional
    public void create(String messageCode, List<SysMessageItemDto> list, String content) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        ArrayList data = Lists.newArrayList();
        for (SysMessageItemDto item : list) {
            SystemMessage cur = new SystemMessage();
            cur.setReadFlag(false);
            cur.setBusinessCode(item.getBusinessCode());
            cur.setBusinessType(item.getBusinessType());
            cur.setRelateCode(item.getRelateCode());
            cur.setRelateType(item.getRelateType());
            cur.setMessageCode(messageCode);
            cur.setContent(ContentHolderUtil.replacePlaceHolder((String)content, (Map)item.getParamsMap()));
            cur.setTenantCode(TenantUtils.getTenantCode());
            data.add(cur);
        }
        this.systemMessageService.createBatch(data);
    }
}

