/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.message.local.service.internal;

import com.biz.crm.common.message.local.entity.SystemMessage;
import com.biz.crm.common.message.local.repository.SystemMessageRepository;
import com.biz.crm.common.message.local.service.SystemMessageService;
import com.biz.crm.common.message.sdk.dto.SysMessageItemDto;
import com.biz.crm.common.message.sdk.register.SystemMessageRegister;
import com.biz.crm.common.message.sdk.service.SystemMessageTypeService;
import com.biz.crm.common.message.sdk.service.SystemMessageVoService;
import com.biz.crm.common.message.sdk.util.ContentHolderUtil;
import com.biz.crm.common.message.sdk.vo.SystemMessageVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SystemMessageVoServiceImpl
implements SystemMessageVoService {
    @Autowired(required=false)
    private SystemMessageService systemMessageService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SystemMessageTypeService systemMessageTypeService;
    @Autowired(required=false)
    private SystemMessageRepository systemMessageRepository;

    @Transactional
    public List<SystemMessageVo> create(String messageCode, List<SysMessageItemDto> list, String content) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        ArrayList data = Lists.newArrayList();
        for (SysMessageItemDto item : list) {
            SystemMessage cur = new SystemMessage();
            cur.setReadFlag(false);
            cur.setBusinessCode(item.getBusinessCode());
            cur.setBusinessType(item.getBusinessType());
            cur.setRelateCode(item.getRelateCode());
            cur.setRelateType(item.getRelateType());
            cur.setMessageCode(messageCode);
            cur.setContent(ContentHolderUtil.replacePlaceHolder((String)content, (Map)item.getParamsMap()));
            cur.setTenantCode(TenantUtils.getTenantCode());
            SystemMessageRegister register = this.systemMessageTypeService.findByCode(cur.getMessageCode());
            if (Objects.nonNull(register)) {
                cur.setMessageName(register.getName());
            }
            data.add(cur);
        }
        this.systemMessageService.createBatch(data);
        return (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)data, SystemMessage.class, SystemMessageVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Integer findHomeNotReadCount() {
        return this.systemMessageRepository.findHomeNotReadCount();
    }
}

