/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.message.sdk.register;

import com.biz.crm.common.message.sdk.dto.SysMessageItemDto;
import com.biz.crm.common.message.sdk.register.SystemMessageHandlerRegister;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public interface SystemMessageRegister {
    public String getCode();

    public String getName();

    default public String getDesc() {
        return "";
    }

    public List<SystemMessageHandlerRegister> getHandlerRegisterList();

    default public int getOrder() {
        return 0;
    }

    @Transactional
    default public void sendMessage(Map<String, List<SysMessageItemDto>> map) {
        List<SystemMessageHandlerRegister> registers = this.getHandlerRegisterList();
        Validate.isTrue((!CollectionUtils.isEmpty(registers) ? 1 : 0) != 0, (String)"\u4e0d\u5b58\u5728\u6d88\u606f\u53d1\u9001\u7684\u5904\u7406\u5668!", (Object[])new Object[0]);
        Map mapRegister = registers.stream().collect(Collectors.toMap(SystemMessageHandlerRegister::getCode, Function.identity(), (a, b) -> a));
        for (Map.Entry<String, List<SysMessageItemDto>> item : map.entrySet()) {
            SystemMessageHandlerRegister register = (SystemMessageHandlerRegister)mapRegister.get(item.getKey());
            Validate.notNull((Object)register, (String)(item.getKey() + "\u5bf9\u5e94\u7684\u5904\u7406\u5668\u4e0d\u5b58\u5728\uff01"), (Object[])new Object[0]);
            register.sendMessage(this.getCode(), item.getValue());
        }
    }
}

