package com.biz.crm.common.message.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import lombok.Data;

/**
 * 消息明细dto
 *
 * @author sunx
 * @date 2022/7/4
 */
@Data
@ApiModel(value = "SysMessageItemDto", description = "消息明细dto")
public class SysMessageItemDto {

  /** 关联业务编码 */
  @ApiModelProperty(value = "关联业务编码")
  private String businessCode;

  /**
   * 关联业务编码类型
   *
   * @see MessageBusinessType
   */
  @ApiModelProperty(value = "关联业务编码类型")
  private String businessType;

  /** 关联单据编码 */
  @ApiModelProperty(value = "关联单据编码")
  private String relateCode;

  /**
   * 关联单据类型
   *
   * @see MessageRelateType
   */
  @ApiModelProperty(value = "关联单据类型")
  private String relateType;

  /** 模板参数，对应SystemMessageHandlerRegister->content->${code} */
  @ApiModelProperty(value = "模板参数")
  private Map<String, String> paramsMap;
}
