package com.biz.crm.common.message.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 系统消息分页查询dto
 *
 * @author sunx
 * @date 2022/7/4
 */
@Data
@ApiModel(value = "SystemMessagePaginationDto", description = "系统消息分页查询dto")
public class SystemMessagePaginationDto {

  /** 关键字搜索 */
  @ApiModelProperty("关键字搜索")
  private String keyword;

  /** 关联业务员编码 */
  @ApiModelProperty("关联业务员编码")
  private String businessCode;

  /** 关联业务员类型 */
  @ApiModelProperty("关联业务员类型")
  private String businessType;

  /** 是否已读 */
  @ApiModelProperty("是否已读")
  private Boolean readFlag;

  /** 租户编码 */
  @ApiModelProperty("租户编码")
  private String tenantCode;
}
