package com.biz.crm.common.message.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 系统消息推送关联业务员类型
 *
 * @author sunx
 * @date 2022/7/4
 */
@Getter
@AllArgsConstructor
public enum MessageBusinessType {
  /** 系统消息推送关联业务员类型 */
  BACKGROUND("background", "background", "后台用户", "0"),
  CUSTOMER("customer", "customer", "经销商用户", "1"),
  TERMINAL("terminal", "terminal", "终端用户", "2"),
  ;
  /** 系统key */
  private String key;
  /** 字典编码 */
  private String dictCode;
  /** 字典值 */
  private String value;
  /** 字典排序 */
  private String order;
}
