package com.biz.crm.common.message.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;

/**
 * 系统消息类型vo
 *
 * @author sunx
 * @date 2022/7/4
 */
@Data
@ApiModel(value = "SystemMessageTypeVo", description = "系统消息类型vo")
public class SystemMessageTypeVo {

  /** 通知类型编码 */
  @ApiModelProperty(value = "通知类型编码")
  private String code;

  /** 通知类型 */
  @ApiModelProperty(value = "通知类型")
  private String name;

  /** 触发规则 */
  @ApiModelProperty(value = "触发规则")
  private String desc;

  /** 被通知方 */
  @ApiModelProperty(value = "被通知方")
  private String noticeDesc;

  /** 排序 */
  @ApiModelProperty(value = "排序")
  private Integer order;

  /** 通知方式名称逗号隔开 */
  @ApiModelProperty(value = "通知方式名称逗号隔开")
  private String itemName;

  /** 通知方式 */
  @ApiModelProperty(value = "通知方式")
  private List<SystemMessageTypeItemVo> items;
}
