/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.business.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.pay.business.sdk.dto.PayBusinessDto;
import com.biz.crm.common.pay.business.sdk.dto.WithdrawalDto;
import com.biz.crm.common.pay.business.sdk.service.PaymentOperationVoService;
import com.biz.crm.common.pay.business.sdk.vo.PaymentOperationVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/pay/operation"})
@Api(tags={"\u652f\u4ed8\u6a21\u5757 \uff1aPaymentOperation \uff1a\u652f\u4ed8\u64cd\u4f5c"})
public class PaymentOperationVoController {
    private static final Logger log = LoggerFactory.getLogger(PaymentOperationVoController.class);
    @Autowired
    private PaymentOperationVoService paymentOperationService;

    @ApiOperation(value="\u63d0\u73b0")
    @PostMapping(value={"withdrawal"})
    public Result<?> withdrawal(@RequestBody WithdrawalDto dto) {
        try {
            String result = this.paymentOperationService.withdrawal(dto);
            return Result.ok((String)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5145\u503c")
    @PostMapping(value={"recharge"})
    public Result<PaymentOperationVo> recharge(@RequestBody PayBusinessDto dto) {
        try {
            PaymentOperationVo vo = this.paymentOperationService.recharge(dto);
            return Result.ok((Object)vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u652f\u4ed8")
    @PostMapping(value={"pay"})
    public Result<PaymentOperationVo> pay(@RequestBody PayBusinessDto dto) {
        try {
            PaymentOperationVo vo = this.paymentOperationService.pay(dto);
            return Result.ok((Object)vo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

