/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.business.local.service.notifier;

import com.biz.crm.common.pay.business.sdk.dto.PayEventDto;
import com.biz.crm.common.pay.business.sdk.enums.PayStatusEnum;
import com.biz.crm.common.pay.business.sdk.event.PayEventListener;
import com.biz.crm.common.pay.business.sdk.service.PaymentRecordVoService;
import com.biz.crm.common.pay.business.sdk.vo.PaymentRecordVo;
import com.biz.crm.common.pay.support.sdk.event.CustomerRechargeListener;
import com.biz.crm.common.pay.support.sdk.vo.transfer.notice.RechargeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class CustomerRechargeListenerImpl
implements CustomerRechargeListener {
    private static final Logger log = LoggerFactory.getLogger(CustomerRechargeListenerImpl.class);
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private PaymentRecordVoService paymentRecordVoService;

    @Transactional
    public void onUnpaid(RechargeVo vo) {
        this.generalValidate(vo);
        PaymentRecordVo byTxSn = this.paymentRecordVoService.findByTxSn(vo.getTxSN());
        Validate.notNull((Object)byTxSn, (String)"\u4e0d\u5b58\u5728\u6d41\u6c34\u8bb0\u5f55", (Object[])new Object[0]);
        this.paymentRecordVoService.updateStatusByTxSn(vo.getTxSN(), PayStatusEnum.UNPAID.getDictCode());
        PayEventDto payEventDto = (PayEventDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)byTxSn, PayEventDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onUnpaid = PayEventListener::onUnpaid;
        this.nebulaNetEventClient.publish((NebulaEventDto)payEventDto, PayEventListener.class, (SerializableBiConsumer)onUnpaid);
    }

    @Transactional
    public void onProcessing(RechargeVo vo) {
        this.generalValidate(vo);
        PaymentRecordVo byTxSn = this.paymentRecordVoService.findByTxSn(vo.getTxSN());
        Validate.notNull((Object)byTxSn, (String)"\u4e0d\u5b58\u5728\u6d41\u6c34\u8bb0\u5f55", (Object[])new Object[0]);
        this.paymentRecordVoService.updateStatusByTxSn(vo.getTxSN(), PayStatusEnum.PROCESSING.getDictCode());
        PayEventDto payEventDto = (PayEventDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)byTxSn, PayEventDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onProcessing = PayEventListener::onProcessing;
        this.nebulaNetEventClient.publish((NebulaEventDto)payEventDto, PayEventListener.class, (SerializableBiConsumer)onProcessing);
    }

    @Transactional
    public void onSuccess(RechargeVo vo) {
        this.generalValidate(vo);
        PaymentRecordVo byTxSn = this.paymentRecordVoService.findByTxSn(vo.getTxSN());
        Validate.notNull((Object)byTxSn, (String)"\u4e0d\u5b58\u5728\u6d41\u6c34\u8bb0\u5f55", (Object[])new Object[0]);
        this.paymentRecordVoService.updateStatusByTxSn(vo.getTxSN(), PayStatusEnum.SUCCESS.getDictCode());
        this.paymentRecordVoService.deleteQRMsgByTxSn(vo.getTxSN());
        PayEventDto payEventDto = (PayEventDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)byTxSn, PayEventDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onSuccess = PayEventListener::onSuccess;
        this.nebulaNetEventClient.publish((NebulaEventDto)payEventDto, PayEventListener.class, (SerializableBiConsumer)onSuccess);
    }

    @Transactional
    public void onFailure(RechargeVo vo) {
        this.generalValidate(vo);
        PaymentRecordVo byTxSn = this.paymentRecordVoService.findByTxSn(vo.getTxSN());
        Validate.notNull((Object)byTxSn, (String)"\u4e0d\u5b58\u5728\u6d41\u6c34\u8bb0\u5f55", (Object[])new Object[0]);
        this.paymentRecordVoService.updateStatusByTxSn(vo.getTxSN(), PayStatusEnum.FAILURE.getDictCode());
        this.paymentRecordVoService.deleteQRMsgByTxSn(vo.getTxSN());
        PayEventDto payEventDto = (PayEventDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)byTxSn, PayEventDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onFailure = PayEventListener::onFailure;
        this.nebulaNetEventClient.publish((NebulaEventDto)payEventDto, PayEventListener.class, (SerializableBiConsumer)onFailure);
    }

    @Transactional
    public void onClose(RechargeVo vo) {
        this.generalValidate(vo);
        PaymentRecordVo byTxSn = this.paymentRecordVoService.findByTxSn(vo.getTxSN());
        Validate.notNull((Object)byTxSn, (String)"\u4e0d\u5b58\u5728\u6d41\u6c34\u8bb0\u5f55", (Object[])new Object[0]);
        this.paymentRecordVoService.updateStatusByTxSn(vo.getTxSN(), PayStatusEnum.CLOSE.getDictCode());
        this.paymentRecordVoService.deleteQRMsgByTxSn(vo.getTxSN());
        PayEventDto payEventDto = (PayEventDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)byTxSn, PayEventDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onClose = PayEventListener::onClose;
        this.nebulaNetEventClient.publish((NebulaEventDto)payEventDto, PayEventListener.class, (SerializableBiConsumer)onClose);
    }

    private void generalValidate(RechargeVo vo) {
        Validate.notNull((Object)vo, (String)"\u4e0d\u5b58\u5728\u76d1\u542c\u5b9e\u4f8b", (Object[])new Object[0]);
        String txSN = vo.getTxSN();
        Validate.notNull((Object)txSN, (String)"\u76d1\u542c\u5b9e\u4f8b\u4e0d\u5b58\u5728\u4ea4\u6613\u6d41\u6c34\u53f7", (Object[])new Object[0]);
    }
}

