package com.biz.crm.common.pay.business.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.pay.business.local.entity.PaymentRecord;
import com.biz.crm.common.pay.business.sdk.dto.PaymentAccountDto;
import com.biz.crm.common.pay.business.sdk.dto.WithdrawalDto;
import com.biz.crm.common.pay.business.sdk.service.PaymentAccountVoService;
import com.biz.crm.common.pay.business.sdk.vo.PaymentAccountExpandVo;
import com.biz.crm.common.pay.business.sdk.vo.PaymentAccountVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 账户vo控制器
 *
 * @author hefan
 * @date 2022/08/08
 */
@RestController
@RequestMapping("/v1/pay/paymentAccount")
@Slf4j
@Api(tags = "支付模块 ：PaymentAccountVo ：支付账号")
public class PaymentAccountVoController {

  @Autowired(required = false)
  private PaymentAccountVoService paymentAccountVoService;

  /**
   * 查询该账户是否已经开通
   */
  @ApiOperation(value = "通过登录租户查询单条数据")
  @GetMapping("isAvailable")
  public Result<Boolean> isAvailable() {
    try {
      Boolean result = paymentAccountVoService.isAvailable();
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 从中金查询用户信息
   * 包括余额
   */
  @ApiOperation(value = "从中金查询用户信息")
  @GetMapping("findUserInfo")
  public Result<PaymentAccountExpandVo> findUserInfo() {
    try {
      PaymentAccountExpandVo result = paymentAccountVoService.findUserInfo();
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查询本地储存的用户信息
   * @return
   */
  @ApiOperation(value = "查询本地储存的用户信息")
  @GetMapping("findLocalUserInfo")
  public Result<PaymentAccountVo> findLocalUserInfo(){
    try {
      PaymentAccountVo result = paymentAccountVoService.findLocalUserInfo();
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 手动录入开户数据
   *
   * @param dto 实体对象
   */
  @ApiOperation(value = "手动录入开户数据")
  @PostMapping
  public Result<?> create(@ApiParam(name = "PaymentRecord", value = "手动录入开户数据") @RequestBody PaymentAccountDto dto) {
    try {
       this.paymentAccountVoService.create(dto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 手动编辑开户数据
   *
   * @param dto 实体对象
   */
  @ApiOperation(value = "手动编辑开户数据")
  @PatchMapping
  public Result<?> update(@ApiParam(name = "PaymentRecord", value = "手动编辑开户数据") @RequestBody PaymentAccountDto dto) {
    try {
      this.paymentAccountVoService.update(dto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
