/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.business.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.pay.business.local.entity.PaymentAccount;
import com.biz.crm.common.pay.business.local.repository.PaymentAccountRepository;
import com.biz.crm.common.pay.business.local.service.PaymentAccountService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="mdmPaymentAccountService")
public class PaymentAccountServiceImpl
implements PaymentAccountService {
    @Autowired
    private PaymentAccountRepository paymentAccountRepository;

    @Override
    public Page<PaymentAccount> findByConditions(Pageable pageable, PaymentAccount mdmPaymentAccount) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull((Object)mdmPaymentAccount)) {
            mdmPaymentAccount = new PaymentAccount();
        }
        return this.paymentAccountRepository.findByConditions(pageable, mdmPaymentAccount);
    }

    @Override
    public PaymentAccount findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (PaymentAccount)((Object)this.paymentAccountRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public PaymentAccount create(PaymentAccount mdmPaymentAccount) {
        this.createValidate(mdmPaymentAccount);
        this.paymentAccountRepository.saveOrUpdate((Object)mdmPaymentAccount);
        return mdmPaymentAccount;
    }

    @Override
    @Transactional
    public PaymentAccount update(PaymentAccount mdmPaymentAccount) {
        this.updateValidate(mdmPaymentAccount);
        this.paymentAccountRepository.saveOrUpdate((Object)mdmPaymentAccount);
        return mdmPaymentAccount;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.paymentAccountRepository.removeByIds(idList);
    }

    @Override
    public PaymentAccount findLocalUserInfo() {
        List<PaymentAccount> byFirmName = this.paymentAccountRepository.findLocalUserInfo();
        if (CollectionUtils.isEmpty(byFirmName)) {
            return null;
        }
        Validate.isTrue((byFirmName.size() == 1 ? 1 : 0) != 0, (String)"\u5f00\u6237\u4fe1\u606f\u53ea\u80fd\u5728\u5f53\u524d\u7cfb\u7edf\u5b58\u5728\u4e00\u6761\u8bb0\u5f55,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Object[])new Object[0]);
        return byFirmName.get(0);
    }

    private void createValidate(PaymentAccount mdmPaymentAccount) {
        Validate.notNull((Object)((Object)mdmPaymentAccount), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        mdmPaymentAccount.setId(null);
        mdmPaymentAccount.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        mdmPaymentAccount.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        mdmPaymentAccount.setTenantCode(TenantUtils.getTenantCode());
        Validate.notNull((Object)mdmPaymentAccount.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(PaymentAccount mdmPaymentAccount) {
        Validate.notNull((Object)((Object)mdmPaymentAccount), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        mdmPaymentAccount.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        mdmPaymentAccount.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        mdmPaymentAccount.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)mdmPaymentAccount.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0cID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)mdmPaymentAccount.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

