package com.biz.crm.common.pay.business.local.service;


import com.biz.crm.common.pay.business.local.entity.PaymentRecord;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.pay.business.sdk.dto.PaymentRecordDto;
import org.springframework.data.domain.Pageable;
import java.util.List;

/**
 * 支付流水表(PaymentRecord)表服务接口
 *
 * @author HanJiaJun
 * @since 2022-08-12 14:02:56
 */
public interface PaymentRecordService {

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param dto 实体对象
   * @return
   */
  Page<PaymentRecord> findByConditions(Pageable pageable, PaymentRecordDto dto);
  
   /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  PaymentRecord findById(String id);
  
   /**
   * 新增数据
   * @param PaymentRecord 实体对象
   * @return 新增结果
   */
  PaymentRecord create(PaymentRecord PaymentRecord);
  
   /**
   * 修改新据
   * @param PaymentRecord 实体对象
   * @return 修改结果
   */
  PaymentRecord update(PaymentRecord PaymentRecord);
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 通过交易流水号改变状态
   * @param txSn
   * @param status
   */
  void updateStatusByTxSn(String txSn, String status);

  /**
   * 查找记录
   * @param txSN
   * @return
   */
  PaymentRecord findByTxSn(String txSN);

  /**
   * 通过订单号查询
   * @param orderNo
   * @return
   */
  PaymentRecord findByOrderNo(String orderNo);

  /**
   * 通过交易流水号删除QR信息
   * @param txSN
   */
  void deleteQRMsgByTxSn(String txSN);
}

