package com.biz.crm.common.pay.business.local.service;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年08月29日 09:40:00
 */
public interface PaymentSmsVerification {

  /**
   * 发送验证码
   * @param phone
   */
  public void sendVerificationCode(String type,String phone);

  /**
   * 生成随机数字验证码
   *
   * @return String
   */
  default String generateVerificationCode() {
    //验证码长度
    int length = 6;
    double random = Math.random();
    return String.format("%0" + length + "d", new BigDecimal(random).multiply(BigDecimal.valueOf(Math.pow(10, length))).setScale(0, RoundingMode.HALF_UP).longValue());
  }
}
