/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.business.local.service.internal;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.pay.business.local.entity.PaymentAccountBank;
import com.biz.crm.common.pay.business.local.repository.PaymentAccountBankRepository;
import com.biz.crm.common.pay.business.local.service.PaymentAccountBankService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="mdmPaymentAccountBankService")
public class PaymentAccountBankServiceImpl
implements PaymentAccountBankService {
    @Autowired
    PaymentAccountBankRepository paymentAccountBankRepository;

    @Override
    @Transactional
    public PaymentAccountBank create(PaymentAccountBank mdmPaymentAccountBank) {
        this.createValidate(mdmPaymentAccountBank);
        this.paymentAccountBankRepository.saveOrUpdate((Object)mdmPaymentAccountBank);
        return mdmPaymentAccountBank;
    }

    @Override
    public void createBrach(List<PaymentAccountBank> mdmPaymentAccountBank) {
        Validate.notEmpty(mdmPaymentAccountBank, (String)"\u521b\u5efa\u65f6\uff0c\u6570\u636e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        for (PaymentAccountBank paymentAccountBank : mdmPaymentAccountBank) {
            this.createValidate(paymentAccountBank);
        }
        this.paymentAccountBankRepository.saveBatch(mdmPaymentAccountBank);
    }

    @Override
    @Transactional
    public PaymentAccountBank update(PaymentAccountBank mdmPaymentAccountBank) {
        this.updateValidate(mdmPaymentAccountBank);
        this.paymentAccountBankRepository.saveOrUpdate((Object)mdmPaymentAccountBank);
        return mdmPaymentAccountBank;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.paymentAccountBankRepository.removeByIds(idList);
    }

    @Override
    public void deleteByAccountId(String accountId) {
        Validate.notBlank((CharSequence)accountId, (String)"\u5220\u9664\u7ed1\u5b9a\u5361\u4fe1\u606f\u65f6\uff0c\u8d26\u6237ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.paymentAccountBankRepository.deleteByAccountId(accountId);
    }

    @Override
    public List<PaymentAccountBank> findByAccountId(String accountId) {
        if (StringUtils.isBlank((CharSequence)accountId)) {
            return new ArrayList<PaymentAccountBank>(0);
        }
        return this.paymentAccountBankRepository.findByAccountId(accountId);
    }

    private void createValidate(PaymentAccountBank mdmPaymentAccountBank) {
        Validate.notNull((Object)((Object)mdmPaymentAccountBank), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        mdmPaymentAccountBank.setId(null);
        mdmPaymentAccountBank.setTenantCode(TenantUtils.getTenantCode());
        mdmPaymentAccountBank.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        mdmPaymentAccountBank.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Validate.notNull((Object)mdmPaymentAccountBank.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(PaymentAccountBank mdmPaymentAccountBank) {
        Validate.notNull((Object)((Object)mdmPaymentAccountBank), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)mdmPaymentAccountBank.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)mdmPaymentAccountBank.getTenantCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

