package com.biz.crm.common.pay.business.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.pay.business.local.entity.PaymentAccount;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 电子账户信息表(MdmPaymentAccount)表服务接口
 *
 * @author HanJiaJun
 * @since 2022-08-18 11:15:12
 */
public interface PaymentAccountService {

  /**
   * 分页查询数据
   *
   * @param pageable          分页对象
   * @param mdmPaymentAccount 实体对象
   * @return
   */
  Page<PaymentAccount> findByConditions(Pageable pageable, PaymentAccount mdmPaymentAccount);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  PaymentAccount findById(String id);

  /**
   * 新增数据
   *
   * @param mdmPaymentAccount 实体对象
   * @return 新增结果
   */
  PaymentAccount create(PaymentAccount mdmPaymentAccount);

  /**
   * 修改新据
   *
   * @param mdmPaymentAccount 实体对象
   * @return 修改结果
   */
  PaymentAccount update(PaymentAccount mdmPaymentAccount);

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 查询开户信息 有且只能有一条记录
   * @return
   */
  PaymentAccount findLocalUserInfo();
}

