package com.biz.crm.common.pay.business.sdk.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author HanJiaJun
 * @describe:  第三方账户信息vo
 * @createTime 2022年08月29日 10:11:00
 */
@Data
public class PaymentAccountExpandVo {
  /**
   * 用户名称
   */
  @ApiModelProperty("用户名称")
  private String userName;
  /**
   * 用户 ID
   */
  @ApiModelProperty("用户 ID")
  private String userID;
  /**
   * 归属父级用户 ID
   */
  @ApiModelProperty("归属父级用户 ID")
  private String parentUserID;
  /**
   * 可用账户余额
   * <p>
   * 注:单位:分
   */
  @ApiModelProperty("可用账户余额")
  private String balance;
  /**
   * 到账余额
   */
  @ApiModelProperty("到账余额")
  private String receivedBalance;
  /**
   * 在途余额
   */
  @ApiModelProperty("在途余额")
  private String receivableBalance;
  /**
   * 冻结账户余额
   */
  @ApiModelProperty("冻结账户余额")
  private String frozenAmount;
  /**
   * 用户类型:
   * <p>
   * 10=个人用户
   * 15=个体工商户用户
   * 20=企业用户
   * 40=匿名用户
   */
  @ApiModelProperty("用户类型")
  private String userType;
  /**
   * 账户状态:
   * <p>
   * 10=正常
   * 30=冻结
   * 35=止付
   */
  @ApiModelProperty("账户状态")
  private String status;

  /**
   * 账户名称
   * 账户编码
   * 账户类型
   * 企业名称
   * 企业邮箱
   * 企业类型
   * 区域
   * 企业规模
   * 统一社会信用代码
   * 开户许可证核准号
   * 对公账户
   * 法人姓名
   * 法人身份证号
   * 法人手机号
   * 法人邮箱
   */
}
