package com.biz.crm.common.pay.business.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年08月18日 11:22:00
 */
@Data
public class PaymentAccountDto extends TenantFlagOpDto {


  @ApiModelProperty("账户流水码")
  private String code;
  /** userId **/
  @ApiModelProperty("userId")
  private String userId;
  /** 机构编号 **/
  @ApiModelProperty("机构编号")
  private String institutionId;
  /** 账户安全手机 **/
  @ApiModelProperty("账户安全手机")
  private String accountPhoneNumber;
  /** 账户名称 **/
  @ApiModelProperty("账户名称")
  private String accountName;
  /** 账户编码 **/
  @ApiModelProperty("账户编码")
  private String accountCode;
  /** 账户类型 **/
  @ApiModelProperty("账户类型")
  private String accountType;

  /** 企业名称 **/
  @ApiModelProperty("企业名称")
  private String firmName;

  /** 企业简称 **/
  @ApiModelProperty("企业简称")
  private String firmShortName;

  /** 分类类别 **/
  @ApiModelProperty("分类类别")
  private String firmType;

  /** 企业邮箱 **/
  @ApiModelProperty("企业邮箱")
  private String firmEmail;

  /** 区域省 **/
  @ApiModelProperty("区域省编码")
  private String provinceCode;

  /** 区域市 **/
  @ApiModelProperty("区域市编码")
  private String cityCode;

  /** 区域区县 **/
  @ApiModelProperty("区域区县编码")
  private String districtCode;
  /** 区域省名称 **/
  @ApiModelProperty("区域省名称")
  private String provinceName;

  /** 区域市名称 **/
  @ApiModelProperty("区域市名称")
  private String cityName;

  /** 区域区县名称 **/
  @ApiModelProperty("区域区县名称")
  private String districtName;


  /** 行业 **/
  @ApiModelProperty("行业")
  private String industry;

  /** 通用行业 **/
  @ApiModelProperty("通用行业")
  private String generalIndustry;

  /** 企业规模 **/
  @ApiModelProperty("企业规模")
  private String scale;

  /** 企业银行账号 **/
  @ApiModelProperty("企业银行账号")
  private String firmBakeNumber;

  /** 开户许可证核准号 **/
  @ApiModelProperty("开户许可证核准号")
  private String licenceNumber;

  /**
   * 证件资料
   */

  /** 营业执照图片地址 **/
  @ApiModelProperty("营业执照图片地址")
  private String  businessLicense;

  /** 统一社会信用代码 **/
  @ApiModelProperty("统一社会信用代码")
  private String socialCreditCode;

  /** 营业执照有效期起 **/
  @ApiModelProperty("营业执照有效期起")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date businessLicenseStartTime;

  /** 营业执照有效期止 **/
  @ApiModelProperty("营业执照有效期止")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date businessLicenseEndTime;

  /** 法人身份证正面图片地址 **/
  @ApiModelProperty("法人身份证正面图片地址")
  private String legalCardFront;

  /** 法人身份证背面图片地址 **/
  @ApiModelProperty("法人身份证背面图片地址")
  private String legalCardBack;

  /** 法人姓名 **/
  @ApiModelProperty("法人姓名")
  private String legalName;

  /** 法人身份证号码 **/
  @ApiModelProperty("法人身份证号码")
  private String legalCardNumber;

  /** 法人身份证有效期起 **/
  @ApiModelProperty("法人身份证有效期起")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date legalCardStartTime;

  /** 法人身份证有效期止 **/
  @ApiModelProperty("法人身份证有效期止")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date legalCardEndTime;

  /** 法人手机号码 **/
  @ApiModelProperty("法人手机号码")
  private String legalPhoneNumber;

  /** 法人邮箱 **/
  @ApiModelProperty("法人邮箱")
  private String legalEmail;

  /** 签约方式 **/
  @ApiModelProperty("签约方式")
  private String contractWay;

  /** 经办人身份证正面图片地址 **/
  @ApiModelProperty("经办人身份证正面图片地址")
  private String agentCardFront;

  /** 经办人身份证背面图片地址 **/
  @ApiModelProperty("经办人身份证背面图片地址")
  private String agentCardBack;

  /** 经办人姓名 **/
  @ApiModelProperty("经办人姓名")
  private String agentName;

  /** 经办人身份证号码 **/
  @ApiModelProperty("经办人身份证号码")
  private String agentCardNumber;

  /** 经办人身份证有效期起 **/
  @ApiModelProperty("经办人身份证有效期起")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date agentCardStartTime;

  /** 经办人身份证有效期止 **/
  @ApiModelProperty("经办人身份证有效期止")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date agentCardEndTime;

  /** 经办人手机号码 **/
  @ApiModelProperty("经办人手机号码")
  private String agentPhoneNumber;

  /** 银行卡列表 **/
  @ApiModelProperty("银行卡列表")
  private List<PaymentAccountBankDto>  bankList;
}
