package com.biz.crm.common.pay.business.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年08月29日 09:51:00
 */
@Getter
@AllArgsConstructor
public enum PayOperationType {
  /**
   * 支付操作类型枚举
   * 充值，支付，提现
   * 目前用于区分手机验证码业务独立性
   */
  WITHDRAWAL("withdrawal", "withdrawal", "提现", "1"),
  RECHARGE("recharge", "recharge", "充值", "2"),
  PAY("pay", "pay", "支付", "4"),
  ;
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  public static PayOperationType getEnumByDictCode(String dictCode) {
    for (PayOperationType item : PayOperationType.values()) {
      if (dictCode.equals(item.getDictCode())) {
        return item;
      }
    }
    return null;
  }
}
