package com.biz.crm.common.pay.business.sdk.service;

import com.biz.crm.common.pay.business.sdk.dto.PaymentRecordDto;
import com.biz.crm.common.pay.business.sdk.vo.PaymentRecordVo;

/**
 * @author HanJiaJun
 * @describe:支付流水VO服务接口
 * @createTime 2022年08月12日 14:34:00
 */
public interface PaymentRecordVoService {

  /**
   * 创建
   *
   * @param dto
   */
  void create(PaymentRecordDto dto);

  /**
   * 更新
   *
   * @param PaymentRecord
   */
  void update(PaymentRecordDto PaymentRecord);

  /**
   * 通过交易流水号，改变状态
   *
   * @param txSn
   * @return
   */
  void updateStatusByTxSn(String txSn, String status);


  /**
   * 查找记录
   * @param txSN
   * @return
   */
  PaymentRecordVo findByTxSn(String txSN);

  /**
   * 通过订单号查找
   * @param OrderNo
   * @return
   */
  PaymentRecordVo findByOrderNo(String OrderNo);

  /**
   * 通过流水号删除 QR信息
   * @param txSN
   */
  void deleteQRMsgByTxSn(String txSN);
}
