package com.biz.crm.common.pay.business.sdk.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author HanJiaJun
 * @describe: 支付DTO  适用与充值、在线支付方式
 * @createTime 2022年08月25日 14:11:00
 */
@Data
public class PayBusinessDto {

  /**
   * 业务订单号
   */
  @ApiModelProperty("业务订单号")
  private String orderNo;

  /**
   * 客户信息编码
   */
  @ApiModelProperty("客户信息编码")
  private String customerCode;
  /**
   *
   */
  @ApiModelProperty("")
  private String terminalUserID;
  /**
   * 付款用户 ID
   */
  @ApiModelProperty("付款用户 ID")
  private String payerUserID;
  /**
   * 收款用户 ID
   */
  @ApiModelProperty("收款用户 ID")
  private String payeeUserID;
  /**
   * 收款用户帐号
   */
  @ApiModelProperty("收款用户帐号")
  private String payeeAccountNumber;

  /**
   * 支付金额
   *
   * 单位:分,PaymentWay=42,ScanPaymentType=40 时,金额可为 0
   */
  @ApiModelProperty("支付金额")
  private String amount;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String goodsName;

  /**
   * 备注
   */
  @ApiModelProperty("备注")
  private String remark;

  /**
   *  支付方式  1代表扫码，2代表小程序跳转支付
   */
  @ApiModelProperty("支付方式（1代表扫码，2代表小程序跳转支付）")
  private String payWay;

  /**
   * AppID(商户进件录入)
   * 微信必填 (小程序跳转支付 字段)
   */
  @ApiModelProperty("AppID(商户进件录入，微信必填 (小程序跳转支付 字段))")
  private String subAppID;
  /**
   * (小程序跳转支付 字段)
   * 用户ID
   * 微信:openid
   * 支付宝: buyer_user_id (必填)
   */
  @ApiModelProperty("用户ID(小程序跳转支付 字段)")
  private String subOpenID;

  @ApiModelProperty("微信CODE")
  private String code;

}
