package com.biz.crm.common.pay.business.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author HanJiaJun
 * @describe: 在线支付流水操作类型枚举
 * @createTime 2022年08月24日 16:06:00
 */
@Getter
@AllArgsConstructor
public enum PayRecordOperationTypeEnum {
  /**
   * 在线支付流水操作类型枚举
   * 订单支付，在线充值，退货退款
   */
  RECHARGE("recharge", "recharge", "在线充值", "1"),
  ORDER("order", "order", "订单支付", "2"),
  RETURN("return", "return", "退货退款", "4"),
      ;
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;
}
