package com.biz.crm.common.pay.business.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author HanJiaJun
 * @describe: 支付状态枚举
 * @createTime 2022年08月24日 16:06:00
 */
@Getter
@AllArgsConstructor
public enum PayStatusEnum {
  /**
   * 支付状态枚举
   * 关闭 失败 成功 处理 未支付
   */
  CLOSE("close", "close", "关闭", "1"),
  FAILURE("failure", "failure", "失败", "2"),
  SUCCESS("success", "success", "成功", "4"),
  PROCESSING("processing", "processing", "处理中", "6"),
  UNPAID("unpaid", "unpaid", "未支付", "9"),
      ;
  /**
   * 系统key
   */
  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;
}
