package com.biz.crm.common.pay.business.sdk.service;

import com.biz.crm.common.pay.business.sdk.dto.PaymentAccountDto;
import com.biz.crm.common.pay.business.sdk.dto.WithdrawalDto;
import com.biz.crm.common.pay.business.sdk.vo.PaymentAccountExpandVo;
import com.biz.crm.common.pay.business.sdk.vo.PaymentAccountVo;

/**
 * 付款账户vo服务
 *
 * @author hefan
 * @date 2022/08/09
 */
public interface PaymentAccountVoService {

  /**
   * 是可用
   *
   * @return {@link Boolean}
   */
  Boolean isAvailable();

  /**
   * 从中金查询用户信息
   * @return
   */
  PaymentAccountExpandVo findUserInfo();

  /**
   * 查询本地储存的用户信息 有且只能有一条记录
   */
  PaymentAccountVo findLocalUserInfo();

  /**
   * 手动录入开户信息
   * @param dto
   */
  void create(PaymentAccountDto dto);

  /**
   * 手动编辑开户数据
   * @param dto
   */
  void update(PaymentAccountDto dto);
}
