package com.biz.crm.common.pay.business.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidFlagOpVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author HanJiaJun
 * @describe: 银行卡信息vo
 * @createTime 2022年08月16日 15:14:00
 */
@Data
public class BankInfoVo extends UuidFlagOpVo {

  /**
   * 账户名称
   */
  @ApiModelProperty("账户名称")
  private String accountName;

  /**
   * 开户行 ID
   * - 注：参考《银行编码表》
   */
  @ApiModelProperty("开户行 ID")
  private String bankID;

  /**
   * 开户银行名称
   */
  @ApiModelProperty("开户银行名称")
  private String bankName;

  /**
   * 银行卡号
   */
  @ApiModelProperty("银行卡号")
  private String bankCardNumber;

  /**
   * 关联客户编码
   */
  @ApiModelProperty("关联客户编码")
  private String customerCode;

  /**
   * 关联客户名称
   */
  @ApiModelProperty("关联客户名称")
  private String customerName;

  /**
   * 银行账户绑定流水号
   */
  @ApiModelProperty("银行账户绑定流水号")
  private String bindingTxSN;
}
