package com.biz.crm.common.pay.business.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author HanJiaJun
 * @describe: 支付流水记录实体
 * @createTime 2022年08月11日 16:33:00
 */
@Data
public class PaymentRecordVo extends TenantVo {
  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 操作类型
   */
  @ApiModelProperty("操作类型")
  private String operationType;

  /**
   * 关联单据号
   */
  @ApiModelProperty("关联单据号")
  private String relationshipDocNumber;

  /**
   * 金额
   */
  @ApiModelProperty("金额")
  private BigDecimal amount;

  /**
   * 操作时间
   */
  @ApiModelProperty("操作时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date operationTime;

  /**
   * 支付宝微信聚合码二维码
   */
  @ApiModelProperty("支付宝微信聚合码二维码")
  private String qrCodeUrl;

  /**
   * 支付宝微信聚合码二维码图片URL
   */
  @ApiModelProperty("支付宝微信聚合码二维码图片URL")
  private String qrImageUrl;


  /**
   * 授权码  跳转支付
   */
  @ApiModelProperty("授权码(跳转支付)")
  private String qrAuthCode;
}
