package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.AbstractTxStrategy;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.enrollment.Tx7704Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.enrollment.Tx7704Response;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 7703-壹企付用户签约入网
 *
 * <pre>
 *    7703 是壹企付用户签约入网接口，机构系统通过该接口将请求 报文发送到支付平台，支付平台立即进行处理，并实时返回受理结果。
 *    如果受理成功，支付平台后续会对该笔交易进行处理，签约成功后会通过7709-壹企付用户签约成功后台通知接口发送至机构系统，
 *    机构系统也可以通过 7704-壹企付用户签约状态查询接口查询签约交易状态。
 * </pre>
 *
 * @author Keller
 */
@Component
@Slf4j
public class Tx7704Strategy extends AbstractTxStrategy<Tx7704Request, Tx7704Response> {

  @Override
  public String getCode() {
    return CpcnRequestType.TX_7704_REQUEST.getCode();
  }

  @Override
  public Class<Tx7704Response> getResponse() {
    return Tx7704Response.class;
  }
}
