package com.biz.crm.common.pay.support.cpcn.service.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.utils.GUID;
import com.biz.crm.common.pay.support.sdk.service.TxSnGenerateService;
import org.springframework.stereotype.Service;

/**
 * @author HanJiaJun
 * @describe: 生成交易流水号
 * @createTime 2022年08月27日 15:43:00
 */
@Service
public class TxSnGenerateServiceImpl implements TxSnGenerateService {
  @Override
  public String create() {
    /**
     * 中金要求格式：
     * -  只能为数字字母开头和结尾
     * -  中间可以包含 ‘-’
     * -  流水号前17位必须是时间戳（yyyyMMddHHmmssSSS)
     * -  调用GUIDGenerator类的genGUID方法生产流水号
     */
    try {
      return GUID.genTxNo(GUID.LEN_27);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }
}
