/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.support.cpcn.service.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.service.TxService;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4695Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4695Response;
import com.biz.crm.common.pay.support.sdk.service.AccountAuthSupportVoService;
import java.util.Collection;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccountAuthSupportVoServiceImpl
implements AccountAuthSupportVoService {
    @Autowired(required=false)
    private TxService<Tx4695Response> tx4695Service;

    public Boolean haveAuthorityToCollectMoney(String userID, String mainUserID) {
        Tx4695Request tx4695Request = this.getTx4695Request(userID, mainUserID, "");
        Tx4695Response tx4695Response = this.tx4695Service.handlerTx(CpcnRequestType.TX_4695_REQUEST.getCode(), tx4695Request);
        return this.haveAuthorityToCollectMoney(tx4695Response);
    }

    private Boolean haveAuthorityToCollectMoney(Tx4695Response response) {
        String code = response.getCode();
        boolean isSuccess = "2000".equals(code);
        if (!isSuccess) {
            return isSuccess;
        }
        Collection<Tx4695Response.Item> item = response.getItem();
        Optional<Tx4695Response.Item> first = item.stream().filter(x -> x.getAuthType().equals("20")).findFirst();
        Tx4695Response.Item item20 = first.get();
        String authFlag = item20.getAuthFlag();
        return authFlag.equals("1");
    }

    private Tx4695Request getTx4695Request(String userID, String mainUserID, String authType) {
        Tx4695Request tx4695Request = new Tx4695Request();
        tx4695Request.setTxCode(CpcnRequestType.TX_4695_REQUEST.getCode());
        tx4695Request.setMainUserID(mainUserID);
        tx4695Request.setAuthType(authType);
        tx4695Request.setUserID(userID);
        return tx4695Request;
    }
}

