package com.biz.crm.common.pay.support.cpcn.base.cpcn.notice;

import com.biz.crm.common.pay.support.cpcn.base.common.utils.XmlUtils;
import lombok.Getter;
import lombok.ToString;
import org.w3c.dom.Document;

/**
 * 5028-退款结果通知
 *
 * @author Keller
 */
@Getter
@ToString
public class Notice5028Request {
  /**
   * 机构编号
   */
  private String institutionID;
  /**
   * 退款流水号
   */
  private String txSN;
  /**
   * 订单号
   */
  private String orderNo;
  /**
   * 退款金额，单位:分
   */
  private String amount;
  /**
   * 撤销金额,单位:分
   */
  private String cancelAmount;
  /**
   * 返还收款用户 手续费总金额, 单位:分
   */
  private String returnPayeeUserFee;
  /**
   * 退款状态
   * <p>
   * 20=退款成功
   * 30=退款失败
   * 40=退票
   */
  private String status;
  /**
   * 退款时间
   * <p>
   * 格式: yyyyMMddHHmmssSSS
   */
  private String responseTime;
  /**
   * 响应代码
   */
  private String responseCode;
  /**
   * 响应消息
   */
  private String responseMessage;

  public Notice5028Request(Document document) throws Exception {
    this.institutionID = XmlUtils.getNodeText(document, "InstitutionID");
    this.txSN = XmlUtils.getNodeText(document, "TxSN");
    this.orderNo = XmlUtils.getNodeText(document, "OrderNo");
    this.amount = XmlUtils.getNodeText(document, "Amount");
    this.cancelAmount = XmlUtils.getNodeText(document, "CancelAmount");
    this.returnPayeeUserFee = XmlUtils.getNodeText(document, "ReturnPayeeUserFee");
    this.status = XmlUtils.getNodeText(document, "Status");
    this.responseTime = XmlUtils.getNodeText(document, "ResponseTime");
    this.responseCode = XmlUtils.getNodeText(document, "ResponseCode");
    this.responseMessage = XmlUtils.getNodeText(document, "ResponseMessage");
  }
}
