package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.notice.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnNoticeType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.notice.Notice5038Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.notice.NoticeRequest;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.service.notifier.Notice5028Listener;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.notice.NoticeStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 *  * 5038-延迟分账通知
 *  * 如果 5031 接口的延迟分账交易实时响应的交易状态（status 字段）为【20- 成功】或者【30-失败】时支付平台会向机构系统发送 5038-延迟分账通知。
 *  * 如果 5031 接口的延迟分账交易实时响应的交易状态（status 字段）为【10-处理中】时，后续交易状态变更为【20-成功】或者【30-失败】时，
 *  * 支付平台会向机构系统发送 5038-延迟分账通知。
 *  * 该通知将延迟分账交易的支付总金额、可用分账金额、分账结算域等信息
 *  * 发送到机构系统（优先向 5038 接口上送的后台通知地址发送，5038 接口没有上
 *  * 送则向机构系统在上线申请时提供的后台通知地址发送）。机构系统收到该通知
 *  * 后需要给支付平台返回特定的响应（详见《中金支付 报文交换技术规范 第 1
 *  * 部分 总体规范》），如果支付平台在 5 秒内未收到机构系统返回的通知响应或
 *  * 接收到的响应内容与规定内容不符，支付平台会认为机构系统未成功收到该通
 *  * 知，这时支付平台会向机构系统补发通知，最多补发两次，共发三次。机构系统
 *  * 收到通知后可以根据通知中的状态字段同步该笔分账交易的状态，也可以通过5036-延迟分账查询接口同步该笔交易的状态。
 * @Author dy
 * @DATE 2022/5/27
 **/
@Slf4j
@Component
public class Notice5038Strategy implements NoticeStrategy<Notice5038Request> {

  @Autowired(required = false)
  private List<Notice5028Listener> notice5028Listeners;

  @Override
  public String getCode() {
    return CpcnNoticeType.NOTICE_5038.getCode();
  }

  @Override
  public Notice5038Request exchange(NoticeRequest request) throws Exception {
    return null;
  }

  @Override
  public void handler(NoticeRequest request) {

  }
}
