package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.AbstractTxStrategy;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4616Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4616Response;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 4616-开户/绑卡查询
 *
 * <pre>
 *    机构系统通过该接口可以对用户开户信息(4601-开户)、银行卡绑定关 系(4611-绑卡)进行查询，
 *    支付平台返回银行电子账户信息、银行卡绑定信息。
 * </pre>
 *
 * @author Keller
 */
@Component
@Slf4j
public class Tx4616Strategy extends AbstractTxStrategy<Tx4616Request, Tx4616Response> {

  @Override
  public String getCode() {
    return CpcnRequestType.TX_4616_REQUEST.getCode();
  }

  @Override
  public Class<Tx4616Response> getResponse() {
    return Tx4616Response.class;
  }
}
