package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseRequest;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.validation.constraints.NotBlank;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

/**
 * 4665-白名单开通/注销
 *
 * @author Keller
 */
@Getter
@Setter
@ToString
public class Tx4665Request extends TxBaseRequest {
  /**
   * 交易流水号
   */
  @NotBlank(message = "交易流水号不能为空")
  private String txSN;
  /**
   * 白名单类型:
   *
   * 10=线下转账充值白名单
   */
  @NotBlank(message = "白名单类型不能为空")
  private String whiteListType;
  /**
   * 操作类型:
   *
   * 10=开通
   * 20=注销
   */
  @NotBlank(message = "操作类型不能为空")
  private String operation;
  /**
   * 付款银行账户名称
   *
   * 白名单类型为10-转账充值白名单时，必填
   */
  private String bankAccountName;
  /**
   * 付款银行账户号码
   *
   * 白名单类型为10-转账充值白名单时，必填
   */
  private String bankAccountNumber;
  /**
   * 收款主用户id
   */
  private String payeeMainUserID;
  /**
   * 收款用户 ID
   */
  private String payeeUserID;

  @Override
  public void process() throws Exception {
    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    Document document = documentBuilder.newDocument();
    Element Request = document.createElement("Request");
    Element Head = document.createElement("Head");
    Element Body = document.createElement("Body");
    Element TxCode = document.createElement("TxCode");
    Element InstitutionID = document.createElement("InstitutionID");
    Element TxSN = document.createElement("TxSN");
    Element WhiteListType = document.createElement("WhiteListType");
    Element Operation = document.createElement("Operation");
    Element BankAccountName = document.createElement("BankAccountName");
    Element BankAccountNumber = document.createElement("BankAccountNumber");
    Element PayeeMainUserID = document.createElement("PayeeMainUserID");
    Element PayeeUserID = document.createElement("PayeeUserID");
    document.appendChild(Request);
    Request.setAttribute("version", "2.1");
    Request.appendChild(Head);
    Head.appendChild(TxCode);
    TxCode.setTextContent(this.txCode);
    Request.appendChild(Body);
    Body.appendChild(InstitutionID);
    InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
    Body.appendChild(TxSN);
    TxSN.setTextContent(this.txSN);
    Body.appendChild(WhiteListType);
    WhiteListType.setTextContent(this.whiteListType);
    Body.appendChild(Operation);
    Operation.setTextContent(this.operation);
    Body.appendChild(BankAccountName);
    BankAccountName.setTextContent(this.bankAccountName);
    Body.appendChild(BankAccountNumber);
    BankAccountNumber.setTextContent(this.bankAccountNumber);
    Body.appendChild(PayeeMainUserID);
    PayeeMainUserID.setTextContent(this.payeeMainUserID);
    Body.appendChild(PayeeUserID);
    PayeeUserID.setTextContent(this.payeeUserID);
    postProcess(document);
  }

}
