/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.support.cpcn.service.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnBillTransactionStatus;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.service.TxService;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4643Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4643Response;
import com.biz.crm.common.pay.support.cpcn.util.SerialNumberUtils;
import com.biz.crm.common.pay.support.sdk.dto.ExtractCashDto;
import com.biz.crm.common.pay.support.sdk.model.ResponseModel;
import com.biz.crm.common.pay.support.sdk.service.BankAccountSupportVoService;
import com.biz.crm.common.pay.support.sdk.service.ExtractCashService;
import com.biz.crm.common.pay.support.sdk.vo.BankAccountSupportVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExtractCashServiceImpl
implements ExtractCashService {
    @Autowired
    private TxService<Tx4643Response> tx4643Service;
    @Autowired
    private CpcnConfig cpcnConfig;
    @Autowired(required=false)
    private BankAccountSupportVoService bankAccountSupportVoService;

    public ResponseModel sendRequest(ExtractCashDto extractCashDto) {
        Tx4643Request tx4643Request = this.getTx4643Request(extractCashDto);
        Tx4643Response response = this.tx4643Service.handlerTx(CpcnRequestType.TX_4643_REQUEST.getCode(), tx4643Request);
        return this.parseResponse(response);
    }

    private ResponseModel parseResponse(Tx4643Response response) {
        String code = response.getCode();
        boolean isSuccess = "2000".equals(code);
        ResponseModel responseModel = new ResponseModel();
        responseModel.setSuccess(Boolean.valueOf(isSuccess));
        if (!isSuccess) {
            responseModel.setMessage(response.getMessage());
            return responseModel;
        }
        String status = response.getStatus();
        boolean isFail = CpcnBillTransactionStatus.FAIL.getCode().equals(status);
        responseModel.setSuccess(Boolean.valueOf(!isFail));
        boolean isDelay = CpcnBillTransactionStatus.PROCESSING.getCode().equals(status);
        responseModel.setDelay(Boolean.valueOf(isDelay));
        responseModel.setMessage(response.getResponseMessage());
        return responseModel;
    }

    private Tx4643Request getTx4643Request(ExtractCashDto extractCashDto) {
        Tx4643Request tx4643Request = new Tx4643Request();
        tx4643Request.setTxCode(CpcnRequestType.TX_4643_REQUEST.getCode());
        tx4643Request.setTxSN(SerialNumberUtils.create());
        tx4643Request.setUserID(extractCashDto.getUserID());
        String bindingTxSN = this.getBindingTxSN(extractCashDto.getBankAccountNumber(), "", extractCashDto.getUserID());
        tx4643Request.setBindingTxSN(bindingTxSN);
        tx4643Request.setAmount(extractCashDto.getAmount());
        tx4643Request.setArrivalType(extractCashDto.getArrivalType());
        tx4643Request.setRemark(extractCashDto.getRemark());
        tx4643Request.setNoticeURL(this.cpcnConfig.getNoticeUrl());
        return tx4643Request;
    }

    private String getBindingTxSN(String bankAccountNumber, String mainUserID, String userID) {
        BankAccountSupportVo bankAccountSupportVo = this.bankAccountSupportVoService.findByBankAccountNumber(bankAccountNumber, mainUserID, userID);
        return bankAccountSupportVo.getBindingTxSN();
    }
}

