package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.gatheringaccredit;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseRequest;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.validation.constraints.NotBlank;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

/**
 * 2735-商户进件状态查询
 *
 * @author Keller
 *
 */
@Getter
@Setter
@ToString
public class Tx2735Request extends TxBaseRequest {
  /**
   * 申请流水号
   */
  @NotBlank(message = "申请流水号不能为空")
  private String applyNo;

  @Override
  public void process() throws Exception {
    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    Document document = documentBuilder.newDocument();
    Element Request = document.createElement("Request");
    Element Head = document.createElement("Head");
    Element Body = document.createElement("Body");
    Element TxCode = document.createElement("TxCode");
    Element InstitutionID = document.createElement("InstitutionID");
    Element ApplyNo = document.createElement("ApplyNo");
    Request.setAttribute("version", "2.1");
    document.appendChild(Request);
    Request.appendChild(Head);
    Head.appendChild(TxCode);
    Request.appendChild(Body);
    Body.appendChild(InstitutionID);
    Body.appendChild(ApplyNo);
    TxCode.setTextContent(this.txCode);
    InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
    ApplyNo.setTextContent(this.applyNo);
    postProcess(document);
  }
}
