package com.biz.crm.common.pay.support.cpcn.base.cpcn.notice;

import com.biz.crm.common.pay.support.cpcn.base.common.utils.XmlUtils;
import lombok.Getter;
import lombok.ToString;
import org.w3c.dom.Document;

/**
 * 4618-开户/绑卡结果通知
 *
 * @author Keller
 */
@Getter
@ToString
public class Notice4618Request {
  /**
   * 机构编号
   */
  private String institutionID;
  /**
   * 原业务流水号
   */
  private String sourceTxSN;
  /**
   * 交易编码:
   *
   * 4601=开户
   * 4611=绑卡
   */
  private String sourceTxCode;
  /**
   * 用户 ID
   */
  private String userID;
  /**
   * 用户类型:
   *
   * 11=个人用户
   * 12=企业用户
   * 13=个体工商
   */
  private String userType;
  /**
   * 归属父级用户ID
   */
  private String parentUserID;
  /**
   * 状态:
   *
   * 18=被动已打款待验证
   * 30=成功
   * 40=失败
   */
  private String status;
  /**
   * 绑卡状态:
   *
   * 20=处理中
   * 30=成功
   * 40=失败
   */
  private String bindingStatus;
  /**
   * 银行账户号码
   */
  private String bankAccountNumber;
  /**
   * 电子账户名称
   */
  private String eAccountName;
  /**
   * 电子账户号码
   */
  private String eAccountNumber;
  /**
   * 线下转账充值开通状态:
   *
   * 10=处理中
   * 20=成功
   * 30=失败
   *
   * 注:仅亿联银行开通线下转账充值功能时出现，不为空。 当绑卡状态为终态时，线下转账充值开通状态才为终态。
   */
  private String transferChargeStatus;
  /**
   * 快捷绑定流水号
   */
  private String bindingTxSN;
  /**
   * 响应码
   */
  private String responseCode;
  /**
   * 响应消息
   */
  private String responseMessage;

  public Notice4618Request(Document document) throws Exception {
    this.institutionID = XmlUtils.getNodeText(document, "InstitutionID");
    this.sourceTxSN = XmlUtils.getNodeText(document, "SourceTxSN");
    this.sourceTxCode = XmlUtils.getNodeText(document, "SourceTxCode");
    this.userID = XmlUtils.getNodeText(document, "UserID");
    this.userType = XmlUtils.getNodeText(document, "UserType");
    this.parentUserID = XmlUtils.getNodeText(document, "ParentUserID");
    this.status = XmlUtils.getNodeText(document, "Status");
    this.bindingStatus = XmlUtils.getNodeText(document, "BindingStatus");
    this.bankAccountNumber = XmlUtils.getNodeText(document, "BankAccountNumber");
    this.eAccountName = XmlUtils.getNodeText(document, "EAccountName");
    this.eAccountNumber = XmlUtils.getNodeText(document, "EAccountNumber");
    this.transferChargeStatus = XmlUtils.getNodeText(document, "TransferChargeStatus");
    this.bindingTxSN = XmlUtils.getNodeText(document, "BindingTxSN");
    this.responseCode = XmlUtils.getNodeText(document, "ResponseCode");
    this.responseMessage = XmlUtils.getNodeText(document, "ResponseMessage");
  }

}
