package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx;

import com.biz.crm.common.pay.support.cpcn.base.common.utils.PayUtils;
import com.biz.crm.common.pay.support.cpcn.base.common.utils.XmlUtils;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import lombok.Getter;
import lombok.ToString;

import org.bouncycastle.util.encoders.Base64;
import org.w3c.dom.Document;

import java.nio.charset.StandardCharsets;

/**
 * 支付请求响应基础抽象类
 *
 * @author Keller
 */
@Getter
@ToString
public abstract class TxBaseResponse {
  /**
   * 响应消息
   */
  protected String responseMessage;
  /**
   * 响应消息签名
   */
  protected String responseSignature;
  /**
   * 响应明文内容
   */
  protected String responsePlainText;
  /**
   * 编号
   */
  protected String code;
  /**
   * 消息
   */
  protected String message;

  public TxBaseResponse(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
    this.responseMessage = responseMessage;
    this.responseSignature = responseSignature;
    byte[] data = Base64.decode(responseMessage);
    this.responsePlainText = new String(data, StandardCharsets.UTF_8);
    byte[] signature = PayUtils.hex2bytes(responseSignature);
    if (!cpcnConfig.getVerifier().verify(data, signature)) {
      throw new Exception("验证签名失败");
    }
    Document document = XmlUtils.createDocument(this.responsePlainText);
    this.code = XmlUtils.getNodeText(document, "Code");
    this.message = XmlUtils.getNodeText(document, "Message");
    //业务实现方法
    process(document);
  }

  protected abstract void process(Document paramDocument) throws Exception;
}
