package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.payroll;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseRequest;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.vo.ImageInfo;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.validation.constraints.NotBlank;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.util.List;

/**
 * 4600-影印件采集
 *
 * @author Keller
 */
@Getter
@Setter
@ToString
public class Tx4600Request extends TxBaseRequest {
  /**
   * 交易流水号
   * 格式:只能为数字字母 开头和结尾, 中间可以 包含 -,流水号前 17 位必须是时间戳
   * ( yyyyMMddHHmmssSSS，数字)，调用 GUIDGenerator 类的 genGUID 方法生成流水 号
   */
  @NotBlank(message = "交易流水号不能为空")
  private String txSN;
  /**
   * 业务类型:
   * <p>
   * 10-壹企付-开户上传身份影印图片(默认)
   * 11-壹企付-实名用户补充影印件
   * 20-薪享付-签约上传身份影印图片
   * 30-信用支付-准入授权影像件
   */
  @NotBlank(message = "业务类型不能为空")
  private String businessType;
  /**
   * 用户类型:
   * <p>
   * 11=个人
   * 12=企业
   * 13=个体户
   */
  @NotBlank(message = "用户类型不能为空")
  private String userType;
  /**
   * 用户 ID，实名用户补充影印件时，必填;仅支 持实名用户补充影印件
   */
  private String userID;
  /**
   * 影印件明细，出现次数大于等于 1 次，单次最 多上送 4 条明细
   */
  private List<ImageInfo> imageInfoList;

  @Override
  public void process() throws Exception {
    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    Document document = documentBuilder.newDocument();
    Element Request = document.createElement("Request");
    Element Head = document.createElement("Head");
    Element TxCode = document.createElement("TxCode");
    Element Body = document.createElement("Body");
    Element InstitutionID = document.createElement("InstitutionID");
    Element TxSN = document.createElement("TxSN");
    Element BusinessType = document.createElement("BusinessType");
    Element UserType = document.createElement("UserType");
    Element UserID = document.createElement("UserID");
    document.appendChild(Request);
    Request.setAttribute("version", "2.1");
    Request.appendChild(Head);
    Head.appendChild(TxCode);
    TxCode.setTextContent(this.txCode);
    Request.appendChild(Body);
    Body.appendChild(InstitutionID);
    InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
    Body.appendChild(TxSN);
    TxSN.setTextContent(this.txSN);
    Body.appendChild(BusinessType);
    BusinessType.setTextContent(this.businessType);
    Body.appendChild(UserType);
    UserType.setTextContent(this.userType);
    Body.appendChild(UserID);
    UserID.setTextContent(this.userID);
    if (this.imageInfoList != null && this.imageInfoList.size() > 0) {
      for (int i = 0; i < this.imageInfoList.size(); i++) {
        ImageInfo imageInfos = this.imageInfoList.get(i);
        Element ImageInfo = document.createElement("ImageInfo");
        Element ImageType = document.createElement("ImageType");
        Element ImageContent = document.createElement("ImageContent");
        Body.appendChild(ImageInfo);
        ImageInfo.appendChild(ImageType);
        ImageInfo.appendChild(ImageContent);
        ImageType.setTextContent(imageInfos.getImageType());
        ImageContent.setTextContent(imageInfos.getImageContent());
      }
    }
    postProcess(document);
  }
}
