package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.statement;

import com.biz.crm.common.pay.support.cpcn.base.common.utils.XmlUtils;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.constant.Constants;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseResponse;
import lombok.Getter;
import org.w3c.dom.Document;

/**
 * 1850-对账文件下载 响应报文
 *
 * @author Keller
 */
@Getter
public class Tx1850Response extends TxBaseResponse {
  /**
   * 对账单下载状态
   * 10=下载成功
   * 20=下载失败
   */
  private String status;
  /**
   * 对账文件，文件名格式:对账日期_批次号.zip 以 Base64 方式传输。(Base64)
   */
  private String billContent;
  /**
   * 响应代码
   */
  private String responseCode;
  /**
   * 响应消息
   */
  private String responseMessage;

  public Tx1850Response(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
    super(responseMessage, responseSignature, cpcnConfig);
  }

  @Override
  protected void process(Document document) throws Exception {
    if (Constants.SUCCESS_CODE.equals(this.code)) {
      this.status = XmlUtils.getNodeText(document, "Status");
      this.billContent = XmlUtils.getNodeText(document, "BillContent");
      this.responseCode = XmlUtils.getNodeText(document, "ResponseCode");
      this.responseMessage = XmlUtils.getNodeText(document, "ResponseMessage");
    }
  }

}
