package com.biz.crm.common.pay.support.cpcn.notifier;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.notice.Notice5018Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.service.notifier.Notice5018Listener;
import com.biz.crm.common.pay.support.sdk.event.CustomerRechargeListener;
import com.biz.crm.common.pay.support.sdk.vo.transfer.notice.RechargeVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 5018-支付通知
 *
 * @author hefan
 * @date 2022/08/26
 */
@Service
public class Notice5018ListenerImpl implements Notice5018Listener {

  @Autowired(required = false)
  private List<CustomerRechargeListener> customerRechargeListeners;

  @Override
  public void onNotice(Notice5018Request request) {
    this.onUnpaid(request);
    this.onProcessing(request);
    this.onSuccess(request);
    this.onFailure(request);
    this.onClose(request);
  }

  /**
   * 在关闭
   *
   * @param request 请求
   */
  private void onClose(Notice5018Request request) {
    String status = request.getStatus();
    boolean isUnpaid = "50".equals(status);
    if (!isUnpaid) {
      return;
    }
    RechargeVo vo = this.getRechargeVo(request);
    if (CollectionUtils.isEmpty(customerRechargeListeners)) {
      return;
    }
    for (CustomerRechargeListener listener : customerRechargeListeners) {
      listener.onClose(vo);
    }
  }

  /**
   * 在失败
   *
   * @param request 请求
   */
  private void onFailure(Notice5018Request request) {
    String status = request.getStatus();
    boolean isUnpaid = "40".equals(status);
    if (!isUnpaid) {
      return;
    }
    RechargeVo vo = this.getRechargeVo(request);
    if (CollectionUtils.isEmpty(customerRechargeListeners)) {
      return;
    }
    for (CustomerRechargeListener listener : customerRechargeListeners) {
      listener.onFailure(vo);
    }
  }

  /**
   * 成功
   *
   * @param request 请求
   */
  private void onSuccess(Notice5018Request request) {
    String status = request.getStatus();
    boolean isUnpaid = "30".equals(status);
    if (!isUnpaid) {
      return;
    }
    RechargeVo vo = this.getRechargeVo(request);
    if (CollectionUtils.isEmpty(customerRechargeListeners)) {
      return;
    }
    for (CustomerRechargeListener listener : customerRechargeListeners) {
      listener.onSuccess(vo);
    }

  }

  /**
   * 在处理
   *
   * @param request 请求
   */
  private void onProcessing(Notice5018Request request) {
    String status = request.getStatus();
    boolean isUnpaid = "20".equals(status);
    if (!isUnpaid) {
      return;
    }
    RechargeVo vo = this.getRechargeVo(request);
    if (CollectionUtils.isEmpty(customerRechargeListeners)) {
      return;
    }
    for (CustomerRechargeListener listener : customerRechargeListeners) {
      listener.onProcessing(vo);
    }
  }

  /**
   * 未支付时通知
   *
   * @param request 请求
   */
  private void onUnpaid(Notice5018Request request) {
    String status = request.getStatus();
    boolean isUnpaid = "10".equals(status);
    if (!isUnpaid) {
      return;
    }
    RechargeVo vo = this.getRechargeVo(request);
    if (CollectionUtils.isEmpty(customerRechargeListeners)) {
      return;
    }
    for (CustomerRechargeListener listener : customerRechargeListeners) {
      listener.onUnpaid(vo);
    }
  }

  /**
   * 把中金返回的数据转成我方业务只关心的数据
   *
   * @param request 请求
   * @return {@link RechargeVo}
   */
  private RechargeVo getRechargeVo(Notice5018Request request) {
    RechargeVo vo = new RechargeVo();
    vo.setOrderNo(request.getOrderNo());
    vo.setTxSN(request.getTxSN());
    vo.setAmount(request.getAmount());
    vo.setPayeeUserID(request.getPayeeUserID());
    vo.setPayeeAccountNumber(request.getPayeeAccountNumber());
    vo.setBankTraceNo(request.getBankTraceNo());
    vo.setExpireTime(request.getExpireTime());
    vo.setPayerID(request.getPayerID());
    vo.setSubOpenID(request.getSubOpenID());
    vo.setActualCardType(request.getActualCardType());
    vo.setResponseTime(request.getResponseTime());
    return vo;
  }


}
