package com.biz.crm.common.pay.support.cpcn.base.cpcn.service.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.notice.NoticeManager;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.notice.NoticeStrategy;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.remote.RemoteManager;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.remote.RemoteStrategy;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.notice.NoticeRequest;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.service.NoticeService;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.vo.NoticeInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 处理中金回调参数
 * 附加对外通知功能（临时添加）
 *
 * @author Keller
 */
@Slf4j
@Service
public class NoticeServiceImpl implements NoticeService {

  @Autowired
  private NoticeManager noticeManager;
  @Autowired
  private CpcnConfig cpcnConfig;
  @Autowired
  private RemoteManager remoteManager;

  @Override
  public void handlerNotice(NoticeInfo info) {
    try {
      log.info("中金原始信息:{}", info.getMessage());
      log.info("中金原始签名:{}", info.getSignature());
      NoticeRequest noticeRequest = new NoticeRequest(info.getMessage(), info.getSignature(), cpcnConfig);
      remoteNotice(info, noticeRequest);
      log.info("中金回调信息:{}", noticeRequest.getPlainText());
      NoticeStrategy service = noticeManager.getHandler(noticeRequest.getTxCode());
      Assert.notNull(service, String.format("获取中金回调处理器为空:[%s]", noticeRequest.getTxCode()));
      service.handler(noticeRequest);
      log.info("中金回调处理结束：{}", noticeRequest.toString());
    } catch (Exception e) {
      log.error("处理中金回调数据出现错误", e);
      throw new IllegalArgumentException(e.getMessage());
    }
  }

  /**
   * 同步通知远程系统（在异常的情况下不影响现有系统的运行）
   *
   * @param noticeInfo
   * @param noticeRequest
   */
  private void remoteNotice(NoticeInfo noticeInfo, NoticeRequest noticeRequest) {
    try {
      List<RemoteStrategy> remoteStrategys = remoteManager.getHandler(noticeRequest.getTxCode());
      if (CollectionUtils.isEmpty(remoteStrategys)) {
        return;
      }
      for (RemoteStrategy remoteStrategy : remoteStrategys) {
        remoteStrategy.handler(noticeInfo);
      }
    } catch (Exception e) {
      log.error(e.getMessage(), e);
    }
  }
}
