package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.AbstractTxStrategy;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4665Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4665Response;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 4665-白名单开通/注销
 *
 * <pre>
 *     4665-白名单开通/注销接口用于多种类型的白名单开通和注销，机构系统通过该接口将开通和注销请求发送到支付平台，
 *     支付平台收到请求后立即处理，并将处理结果实时返回给机构系统。
 * </pre>
 *
 * @author Keller
 */
@Component
@Slf4j
public class Tx4665Strategy extends AbstractTxStrategy<Tx4665Request, Tx4665Response> {

  @Override
  public String getCode() {
    return CpcnRequestType.TX_4665_REQUEST.getCode();
  }

  @Override
  public Class<Tx4665Response> getResponse() {
    return Tx4665Response.class;
  }
}
