/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.support.cpcn.service.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.service.TxService;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4693Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4693Response;
import com.biz.crm.common.pay.support.sdk.service.BankAccountSupportVoService;
import com.biz.crm.common.pay.support.sdk.vo.BankAccountSupportVo;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BankAccountSupportVoServiceImpl
implements BankAccountSupportVoService {
    @Autowired(required=false)
    private TxService<Tx4693Response> tx4693Service;

    public Collection<BankAccountSupportVo> findAll(String mainUserID, String userID) {
        Tx4693Request tx4693Request = this.getTx4693Request(mainUserID, userID);
        Tx4693Response tx4693Response = this.tx4693Service.handlerTx(CpcnRequestType.TX_4693_REQUEST.getCode(), tx4693Request);
        return this.parseResponse(tx4693Response);
    }

    private Collection<BankAccountSupportVo> parseResponse(Tx4693Response response) {
        String code = response.getCode();
        boolean isSuccess = "2000".equals(code);
        if (!isSuccess) {
            throw new RuntimeException(response.getMessage());
        }
        Collection<Tx4693Response.BankAccount> bankAccounts = response.getBankAccounts();
        List<BankAccountSupportVo> bankAccountVos = bankAccounts.stream().map(bankAccount -> {
            BankAccountSupportVo vo = new BankAccountSupportVo();
            vo.setBindingTxSN(bankAccount.getBindingTxSN());
            vo.setBankID(bankAccount.getBankID());
            vo.setBankAccountType(bankAccount.getBankAccountType());
            vo.setBankAccountName(bankAccount.getBankAccountName());
            vo.setBankAccountNumber(bankAccount.getBankAccountNumber());
            vo.setBranchName(bankAccount.getBranchName());
            vo.setBankPhoneNumber(bankAccount.getBankPhoneNumber());
            vo.setCardBusinessType(bankAccount.getCardBusinessType());
            vo.setTransferChargeFlag(bankAccount.getTransferChargeFlag());
            vo.setPayeeUserID(bankAccount.getPayeeUserID());
            vo.setPayeeUserName(bankAccount.getPayeeUserName());
            return vo;
        }).collect(Collectors.toList());
        return bankAccountVos;
    }

    private Tx4693Request getTx4693Request(String mainUserID, String userID) {
        Tx4693Request tx4693Request = new Tx4693Request();
        tx4693Request.setTxCode(CpcnRequestType.TX_4693_REQUEST.getCode());
        tx4693Request.setMainUserID(mainUserID);
        tx4693Request.setUserID(userID);
        return tx4693Request;
    }

    public BankAccountSupportVo findByBankAccountNumber(String bankAccountNumber, String mainUserID, String userID) {
        Collection<BankAccountSupportVo> bankAccountSupportVos = this.findAll(mainUserID, userID);
        Validate.isTrue((!CollectionUtils.isEmpty(bankAccountSupportVos) ? 1 : 0) != 0, (String)"\u6ca1\u6709\u67e5\u8be2\u5230\u53ef\u7528\u7684\u94f6\u884c\u8d26\u6237", (Object[])new Object[0]);
        Set bankAccountSet = bankAccountSupportVos.stream().filter(account -> !account.getBankAccountNumber().equals(bankAccountNumber)).collect(Collectors.toSet());
        Validate.isTrue((!CollectionUtils.isEmpty(bankAccountSet) ? 1 : 0) != 0, (String)"\u8be5\u94f6\u884c\u8d26\u6237\u4e0d\u5728\u4e2d\u91d1\u8d26\u6237\u7684\u7ed1\u5b9a\u5217\u8868\u4e2d", (Object[])new Object[0]);
        Validate.isTrue((bankAccountSet.size() == 1 ? 1 : 0) != 0, (String)"\u67e5\u8be2\u5230\u591a\u4e2a\u94f6\u884c\u8d26\u6237\uff0c\u4e0d\u662f\u4e00\u4e2a\u552f\u4e00\u786e\u5b9a\u7684\u94f6\u884c\u8d26\u6237\u662f\u65e0\u6cd5\u63d0\u73b0\u7684", (Object[])new Object[0]);
        Optional first = bankAccountSet.stream().findFirst();
        BankAccountSupportVo bankAccountSupportVo = (BankAccountSupportVo)first.get();
        return bankAccountSupportVo;
    }
}

