package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseRequest;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.validation.constraints.NotBlank;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

/**
 * 4611-绑卡
 *
 * @author Keller
 */
@Getter
@Setter
@ToString
public class Tx4611Request extends TxBaseRequest {
  /**
   * 银行账户绑
   *
   * 注: 格式:只能为数字定流水号
   */
  @NotBlank(message = "银行账户绑不能为空")
  private String bindingTxSN;
  /**
   * 用户ID
   *
   * 注:用户 ID 上送规则: 数字/字母/数字+字母 注:仅支持实名企业用
   */
  @NotBlank(message = "用户ID不能为空")
  private String userID;
  /**
   * 收款用户ID
   *
   * 注:仅支持实名企业用户;
   */
  private String payeeUserID;
  /**
   * 确权方式
   *
   * 确权方式 第一位=数字证书 第二位=短信验证 第三位=邮件验证 第四位=支付密码 第五位=指纹 第六位=人脸识别 第七位=电子签名 第八位=默认自动支付 第九位=签约自动支付 说明:1 表示该确权信息上送，0 表示该确权信息未上送
   * 如 1011111，表示数字证书、短信验证、邮件验证、支付密码、指纹、电子签名五种确权信息，而人脸识别、默认自动支付、签约自动 支付不是上送确权信息中金账户必填
   *
   */
  private String acceptanceConfirmType;
  /**
   * 卡类型
   *
   * 10=借记账户
   * 20=贷记账户
   *
   * 注:卡类型 20=贷记账户(仅支持个人) 注:操作标识 OperationFlag=10 和个人时必填
   */
  private String bankCardType;
  /**
   * 操作标识:
   *
   * 10=绑卡
   * 20=解绑
   * 30=升级
   *
   * 注:30=升级指提现卡升级至快捷卡，不支持企业银行账户
   */
  private String operationFlag;
  /**
   * 绑卡升级交易流水号
   *
   * 注:格式:只能为数字字母开头和结尾, 中间可以包含 -,流水号前17位必须是时间戳
   * ( yyyyMMddHHmmssSSS，数字)，操作标识为 30-升级时，必填，与BindingTxSN不同。
   */
  private String upgradeTxSN;
  /**
   * 绑卡验证方式:
   *
   * 10=短信验证-快捷绑卡
   * 20=小额打款-提现绑卡
   * 30=静默绑卡-提现绑卡
   * 40=一键绑卡-快捷绑卡
   *
   * 注: 10=短信验证(同时开 通提现和支付业务) 20=小额打款(仅实名用户，仅开通提现业务) 30=静默绑卡(仅实名 用户，仅开通提现业务)
   * 操作标识为10-绑卡时: 个人银行账户支持全部验证方式，默认为 10-短信验证-快捷绑卡; 企业银行账户仅支持20、30 验证方式，默认为 20-小额打款-提现绑卡
   * 操作标识为30-升级时: 升级提现卡为快捷卡必填，且仅支持10-短信验证; 升级开通转账充值功能时，亿联银行存管可为空。例:绑卡验证方式为空，转账充值标识为1-开通，则仅开通转账充值功能;如绑卡验证方式为10-短信验证，转账充值标识为1-开通，则升级快捷卡的同时，开通转账充值功能。
   */
  private String bindingWay;
  /**
   * 证件类型
   *
   * 0=身份证
   *
   * 注:操作标识 OperationFlag=10 时和个人时必填
   */
  private String credentialType;
  /**
   * 身份证号
   *
   * 注:操作标识 OperationFlag=10 时和个人时必填
   */
  private String credentialNumber;
  /**
   * 绑定银行ID
   *
   * 注:参考《银行编码表》;操作标识 OperationFlag=10 时必填
   */
  private String bankID;
  /**
   * 账户类型:
   *
   * 11=个人账户
   * 12=企业账户
   *
   * 注:操作标识 OperationFlag=10 时必填
   */
  private String bankAccountType;
  /**
   * 银行账户名称
   *
   * 注:操作标识OperationFlag=10 时，必填
   */
  private String bankAccountName;
  /**
   * 银行账户号码
   *
   * 注:操作标识OperationFlag=10 和，除一键绑卡外的验证方式，必填
   */
  private String bankAccountNumber;
  /**
   * 银行卡预留手机号码
   *
   * 注:操作标识OperationFlag=10 和个人时必填
   */
  private String bankPhoneNumber;
  /**
   * 分支行名称
   *
   * 注:操作标识OperationFlag=10 和企业时必填
   */
  private String branchName;
  /**
   * 人民银行联行号
   */
  private String cNAPSCode;
  /**
   * 省份
   *
   * 注:企业绑卡必填;
   */
  private String province;
  /**
   * 城市
   *
   * 注:企业绑卡必填;
   */
  private String city;
  /**
   * 信用卡有效期
   *
   * 注:格式 YYMM;
   */
  private String validDate;
  /**
   * 信用卡背面的末3位数字
   */
  private String cVN2;
  /**
   * 转账充值开通标识:
   *
   * 0=不开通
   * 1=开通
   *
   * 注:默认值为0-不开通仅支持实名账户&机构亿联银行存管模式支持开通，其他模式上送1-开通均为不开通。
   */
  private String transferChargeFlag;
  /**
   * 后台通知地址
   *
   * 注:商户上传已这个地址为准，商户未上传一机构配置后台通知为准
   */
  private String noticeURL;
  /**
   * 页面通知地址
   *
   * 注:一键绑卡必填，绑卡成功后跳转地址
   */
  private String pageURL;

  @Override
  public void process() throws Exception {
    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    Document document = documentBuilder.newDocument();
    Element Request = document.createElement("Request");
    Element Head = document.createElement("Head");
    Element Body = document.createElement("Body");
    Element TxCode = document.createElement("TxCode");
    Element InstitutionID = document.createElement("InstitutionID");
    Element BindingTxSN = document.createElement("BindingTxSN");
    Element UserID = document.createElement("UserID");
    Element PayeeUserID = document.createElement("PayeeUserID");
    Element AcceptanceConfirmType = document.createElement("AcceptanceConfirmType");
    Element BankCardType = document.createElement("BankCardType");
    Element OperationFlag = document.createElement("OperationFlag");
    Element UpgradeTxSN = document.createElement("UpgradeTxSN");
    Element BindingWay = document.createElement("BindingWay");
    Element CredentialType = document.createElement("CredentialType");
    Element CredentialNumber = document.createElement("CredentialNumber");
    Element BankID = document.createElement("BankID");
    Element BankAccountType = document.createElement("BankAccountType");
    Element BankAccountName = document.createElement("BankAccountName");
    Element BankAccountNumber = document.createElement("BankAccountNumber");
    Element BankPhoneNumber = document.createElement("BankPhoneNumber");
    Element BranchName = document.createElement("BranchName");
    Element CNAPSCode = document.createElement("CNAPSCode");
    Element Province = document.createElement("Province");
    Element City = document.createElement("City");
    Element ValidDate = document.createElement("ValidDate");
    Element CVN2 = document.createElement("CVN2");
    Element TransferChargeFlag = document.createElement("TransferChargeFlag");
    Element NoticeURL = document.createElement("NoticeURL");
    Element PageURL = document.createElement("PageURL");
    document.appendChild(Request);
    Request.setAttribute("version", "2.1");
    Request.appendChild(Head);
    Head.appendChild(TxCode);
    TxCode.setTextContent(this.txCode);
    Request.appendChild(Body);
    Body.appendChild(InstitutionID);
    InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
    Body.appendChild(BindingTxSN);
    BindingTxSN.setTextContent(this.bindingTxSN);
    Body.appendChild(UserID);
    UserID.setTextContent(this.userID);
    Body.appendChild(PayeeUserID);
    PayeeUserID.setTextContent(this.payeeUserID);
    Body.appendChild(AcceptanceConfirmType);
    AcceptanceConfirmType.setTextContent(this.acceptanceConfirmType);
    Body.appendChild(BankCardType);
    BankCardType.setTextContent(this.bankCardType);
    Body.appendChild(OperationFlag);
    OperationFlag.setTextContent(this.operationFlag);
    Body.appendChild(UpgradeTxSN);
    UpgradeTxSN.setTextContent(this.upgradeTxSN);
    Body.appendChild(BindingWay);
    BindingWay.setTextContent(this.bindingWay);
    Body.appendChild(CredentialType);
    CredentialType.setTextContent(this.credentialType);
    Body.appendChild(CredentialNumber);
    CredentialNumber.setTextContent(this.credentialNumber);
    Body.appendChild(BankID);
    BankID.setTextContent(this.bankID);
    Body.appendChild(BankAccountType);
    BankAccountType.setTextContent(this.bankAccountType);
    Body.appendChild(BankAccountName);
    BankAccountName.setTextContent(this.bankAccountName);
    Body.appendChild(BankAccountNumber);
    BankAccountNumber.setTextContent(this.bankAccountNumber);
    Body.appendChild(BankPhoneNumber);
    BankPhoneNumber.setTextContent(this.bankPhoneNumber);
    Body.appendChild(BranchName);
    BranchName.setTextContent(this.branchName);
    Body.appendChild(CNAPSCode);
    CNAPSCode.setTextContent(this.cNAPSCode);
    Body.appendChild(Province);
    Province.setTextContent(this.province);
    Body.appendChild(City);
    City.setTextContent(this.city);
    Body.appendChild(ValidDate);
    ValidDate.setTextContent(this.validDate);
    Body.appendChild(CVN2);
    CVN2.setTextContent(this.cVN2);
    Body.appendChild(TransferChargeFlag);
    TransferChargeFlag.setTextContent(this.transferChargeFlag);
    Body.appendChild(NoticeURL);
    NoticeURL.setTextContent(this.noticeURL);
    Body.appendChild(PageURL);
    PageURL.setTextContent(this.pageURL);
    postProcess(document);
  }
}
