/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.remote.internal;

import com.biz.crm.common.pay.support.cpcn.base.common.http.HttpData;
import com.biz.crm.common.pay.support.cpcn.base.common.http.NameValuePair;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnNoticeType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.configuration.CpcnProperties;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.remote.RemoteStrategy;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.vo.NoticeInfo;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class Remote7709Strategy
implements RemoteStrategy {
    private static final Logger log = LoggerFactory.getLogger(Remote7709Strategy.class);
    @Autowired
    private CpcnProperties cpcnProperties;
    @Autowired
    private CloseableHttpClient client;

    @Override
    public String getCode() {
        return CpcnNoticeType.NOTICE_7709.getCode();
    }

    @Override
    @Async(value="defaultRemoteNoticeExecutor")
    public void handler(NoticeInfo info) {
        if (ArrayUtils.isNotEmpty((Object[])this.cpcnProperties.getRemoteUrl())) {
            String[] urls;
            NameValuePair message = new NameValuePair("message", info.getMessage());
            NameValuePair signature = new NameValuePair("signature", info.getSignature());
            ArrayList params = Lists.newArrayList((Object[])new NameValuePair[]{message, signature});
            for (String remoteUrl : urls = this.cpcnProperties.getRemoteUrl()) {
                try {
                    String response = this.execute(remoteUrl, params);
                    log.info("\u8c03\u7528\u5e94\u7528\u63a5\u53e3 :'{}',\u8fd4\u56de\u7ed3\u679c\u4e3a:'{}'", (Object)remoteUrl, (Object)response);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        } else {
            log.info("\u672a\u914d\u7f6e\u8f6c\u53d1\u5730\u5740\uff0c7709\u54cd\u5e94\u8bf7\u6c42\u672a\u8f6c\u53d1");
        }
    }

    private String execute(String uri, List<NameValuePair> list) {
        HttpData httpData = new HttpData(list, "UTF-8");
        String request = httpData.getData();
        HttpPost httpPost = new HttpPost(uri);
        BasicHeader basicHeader = new BasicHeader("Content-Type", "application/x-www-form-urlencoded");
        httpPost.addHeader((Header)basicHeader);
        String response = null;
        HttpEntity httpEntity = null;
        try {
            StringEntity stringEntity = new StringEntity(request, Charset.forName("UTF-8"));
            httpPost.setEntity((HttpEntity)stringEntity);
            CloseableHttpResponse closeableHttpResponse = this.client.execute((HttpUriRequest)httpPost);
            httpEntity = closeableHttpResponse.getEntity();
            Validate.notNull((Object)httpEntity, (String)"httpclient\u8bf7\u6c42\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u5730\u5740\uff01", (Object[])new Object[0]);
            response = EntityUtils.toString((HttpEntity)httpEntity, (Charset)Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            log.error("httpclient \u8bf7\u6c42\u9519\u8bef", (Throwable)e);
            throw new RuntimeException(e);
        }
        return response;
    }
}

