package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.aggregate;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseRequest;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.vo.SplitItem;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.validation.constraints.NotBlank;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.util.List;

/**
 * 5011-支付(API)
 *
 * @author Keller
 */
@Getter
@Setter
@ToString
public class Tx5011Request extends TxBaseRequest {
  /**
   * 交易流水号
   *
   * 格式:只能为数字字 母 开头和结尾, 中间 可以包含 -
   */
  @NotBlank(message = "交易流水号不能为空")
  private String txSN;
  /**
   * 业务订单号
   */
  private String orderNo;

  private String terminalUserID;
  /**
   * 付款用户 ID
   */
  private String payerUserID;
  /**
   * 收款用户 ID
   */
  private String payeeUserID;
  /**
   * 收款用户帐号
   */
  private String payeeAccountNumber;
  /**
   * 支付方式:
   *
   * 00=余额支付
   * 02=信用支付
   * 10=快捷支付
   * 20=网银支付
   * 30=代收支付
   * 40=聚合支付(停止 接入新商户)
   * 42=条码支付
   * 43-扫码预授权
   * 50=O2O
   * 60=POS(暂不支 持)
   * 80-跳转支付
   */
  private String paymentWay;
  /**
   * 支付金额
   *
   * 单位:分,PaymentWay=42,ScanPaymentType=40 时,金额可为 0
   */
  private String amount;
  /**
   * 交易失效时间
   *
   * 目前仅支持聚合支付，扫码支付默认为24小时(24*60分钟)，最长30天，单位:分钟
   * 跳转支付默认为10分钟，有效范围:5-120分钟，单位:分钟
   * O2O支付,格式 1-30, 默认30天,单位:天;
   * 1c 为当天(仅支持PaymentWay=50-O2O)；
   * m 为分钟、h 为小时、d 为天、1c 为当天。
   * 例如：15m、12h、3d。
   */
  private String expirePeriod;
  /**
   * 交易发起时间
   * 格式：
   * yyyyMMddHHmmss,
   * 商户交易发起的时间
   * (1c 时有效)。
   */
  private String sourceTxTime;
  /**
   * 回调 URL 地址
   */
  private String pageURL;
  /**
   * 订单优惠标记
   * (使用代金券或立减优惠功能必填)
   */
  private String goodsTag;
  /**
   * 商品名称
   *
   * PaymentWay=02/40/42/80 必填
   */
  private String goodsName;
  /**
   * 平台名称
   *
   * PaymentWay=80必填
   */
  private String platformName;
  /**
   * 用户 IP
   *
   * PaymentWay=80必填
   */
  private String clientIP;
  /**
   * 是否有后续分账:
   *
   * 1-否
   * 2-是
   *
   * 默认为否
   */
  private String hasSubsequentSplit;
  /**
   * 后台通知地址
   *
   * 注:商户上传以这个地址为准，商户未上传以机构配置后台通知为准
   */
  private String noticeURL;
  /**
   * 备注
   *
   * Payment=30 且是对公支付业务时,必传
   */
  private String remark;
  /**
   * 手续费扣收方式是实时扣收时必填
   */
  private String deductionSettlementFlag;
  /**
   * 扩展域
   */
  private String extension;
  /**
   * 是否需要短信验证:
   * 0-不需要
   * 1-需要
   *
   * 支付方式:10 时必填
   */
  private String sMSVerification;
  /**
   * 快捷绑定流水号
   *
   * 支付方式:10 时必填
   */
  private String bindingTxSN;
  /**
   * 分期期数
   *
   * 支付方式:10 时必填
   */
  private String installmentPeriods;
  /**
   * 手续费收取模式
   *
   * 10-商户贴息
   * 20-持卡人付息
   *
   * 支付方式:10 时必填
   */
  private String interestType;
  /**
   * CVN2
   *
   * 支付方式:10 时必填
   */
  private String cVN2;
  /**
   * 有效期
   *
   * 支付方式:10 时必填
   */
  private String validateDate;
  /**
   * 商户贴息费率（单位：百分比）
   *
   * 手续费收取模式为 11-商户部分贴息时必填；
   * 如费率为 5.362%，则传 5.362，支持 3 位小数
   */
  private String feeRate;
  /**
   * 账户类型:
   *
   * 11=个人账户
   * 12=企业账户
   *
   * 支付方式:20 时必填
   */
  private String bankAccountType;
  /**
   * 卡类型:
   *
   * 10=借记账户
   * 20=贷记账户
   *
   * BankAccountType=11时必填
   */
  private String bankCardType;
  /**
   * 银行 ID
   */
  private String bankID;
  /**
   * 账户名称
   */
  private String accountName;
  /**
   * 账户号码
   */
  private String accountNumber;
  /**
   * 个人证件类型
   *
   * 0=身份证
   * 1=户口簿
   * 2=护照
   * 3=军官证
   * 4=士兵证
   * 5=港澳居民来往内地通行证
   * 6=台湾同胞来往内地通行证
   * 7=临时身份证
   * 8=外国人居留证
   * 9=警官证
   * X=其他证件与证件号码同时出现或同时不出现
   */
  private String identificationType;
  /**
   * 证件号码，与证件类型同时出现或同时不出现
   */
  private String identificationNumber;
  /**
   * 手机号
   */
  private String phoneNumber;
  /**
   * 委托协议号,对公结算卡业务必填
   */
  private String entrustNo;
  /**
   * 凭证号,对公结算卡业务必填,传凭证号 (token)
   */
  private String tokenNo;
  /**
   * 聚合支付类型:
   *
   * 10=微信
   * 20=支付宝
   * 30=银联
   *
   * 支付方式: PaymentWay=40必填
   *
   */
  private String qRPaymentType;
  /**
   * 聚合支付方式:
   * 41=正扫
   * 42=反扫
   * 43=公众号(服务窗)
   * 44=小程序
   * 45=H5
   * 46=APP
   *
   * 支付方式: PaymentWay=40必填
   */
  private String qRPaymentWay;
  /**
   * 预下单订单号
   *
   * 支付场景PaymentScene为90-刷脸支付为必输项，且必须与预下单交易一致
   */
  private String preTxSN;
  /**
   * 支付场景
   *
   * 10=条码支付
   * 20=声波支付
   * 90=刷脸支付
   *
   * 聚合支付方式 QRPaymentWay 为反扫时必填，默认10=条码支付
   */
  private String paymentScene;
  /**
   * 反扫支付授权码
   *
   * QRPaymentWay=42时必填
   */
  private String qRPayCode;
  /**
   * 付款用户 openid
   *
   * QRPaymentWay=43 、44时必填，微信: openid，支付宝: buyer_user_id
   */
  private String openID;
  /**
   * 商户 APPID
   *
   * QRPaymentWay=43、44、46时必填
   */
  private String merchantAppID;
  /**
   * 信用卡限制标识
   *
   *  QRPaymentWay=41/42时选填，默认10
   *
   *  10=信用卡可用
   *  20=信用卡不可用
   */
  private String qRLimitPay;

  /**
   * 机具终端 ID
   *
   * 支付类型 QRPaymentType=30 银联，聚合支付方式为 42-反扫时必填
   */
  private String terminalID;

  /**
   * 页面跳转方式
   * 10=公众号
   * 20=小程序
   */
  private String qRPageUrlType;
  /**
   * 跳转前来源
   * 10=App,20=H5,30=公众号,40=小程序
   */
  private String redirectSource;
  /**
   * 支付方式
   *
   * 45=H5支付 (PayType=30、31、32、33)
   * 46=APP 支付 (PayType=30、31、32、33)
   * 47=手机迷你付(PayType=33)
   * 48=手机Pay (PayType=34、35)
   * 50=JSAPI (PayType=31、32)
   * 51=小程序支付 (PayType=31)
   */
  private String payWay;
  /**
   * 支付类型
   *
   * 30=手机网银
   * 31=微信
   * 32=支付宝
   * 33=银联
   * 34=Apple Pay
   * 35=Android Pay
   */
  private String payType;
  /**
   * 发卡行
   *
   * 参考《银行编码表》 PayType=30 时必填InstallmentType=20时必填 (支付宝分期不需 要填)
   */
  private String redirectPayBankID;
  /**
   * 支付方式限制:
   *
   * 10=不限定
   * 20=仅支持借记卡
   * 30=仅支持贷记卡 (PayType=30、 PayWay=45/46时可用，并且不为空)
   * 默认值 10
   */
  private String limitPay;
  /**
   * 实名验证信息
   *
   * 保险实名认证商户必填
   */
  private String identityInfo;
  /**
   * AppID(商户进件录入)
   * 微信必填PayType=31支付宝选填(支付宝直连必填)
   */
  private String subAppID;
  /**
   * 用户ID 微信:openid 支付宝: buyer_user_id (PayWay=50/51必填)
   */
  private String subOpenID;
  /**
   * 分期控制标识 10-不指定分期 20-指定分期 PayType=32、33，PayWay=45- H5支付时必填
   */
  private String installmentType;
  /**
   * 手续费收取模式:
   *
   * 10=商户贴息
   * 20=持卡人付费
   *
   * InstallmentType=20时必填
   */
  private String feeMode;
  /**
   * 支付类型为
   *
   * 33、分期控制标识为 20-指定分期必填(支付宝分期不需要填)
   */
  private String bankAccountNumber;
  /**
   * 卡号掩码
   *
   * 当为银联 H5 分期（含分期信息码）时，InstallmentForce=10时可以强制限定
   */
  private String maskAccNo;
  /**
   * 使用强制使用上送的限定信息进行分期支付
   * 10：是，强制使用限定信息进行分期支付
   * 20：否，默认展示限定信息，用户在支付时可以重选；
   *
   * PayType=33、 PayWay=45，InstallmentType=20
   * 指定分期时(银联 H5分期)必填
   */
  private String installmentForce;
  /**
   * 是否登录,标识该用户是否已登录：
   * 10：已登录
   * 20：未登录
   */
  private String loginState;
  /**
   * 分期期数 分期控制标识20指定分期时必填
   */
  private String numberOfInstallments;
  /**
   * 条码支付类型:
   *
   * 10=微信
   * 20=支付宝
   * 30=银联
   * 40=聚合码
   */
  private String scanPaymentType;
  /**
   * 条码支付方式:
   *
   * 41=正扫
   * 42=反扫
   */
  private String scanPaymentWay;
  /**
   * 反扫支付授权码
   */
  private String scanPaymentCode;
  /**
   * 账户类型
   * 11=个人账户（默认）
   * 12=企业账户
   */
  private String accountType;
  /**
   * 信用卡限制标识
   *
   * 10=信用卡可用
   * 20=信用卡不可用
   * 99=无关
   */
  private String scanPaymentLimitFlag;
  /**
   * 取消支付后的前台跳转页面
   *
   * QRPaymentWay=41时,填入有效持卡人取消支付后跳转到此页面，应更换支付流水号后再次唤起支付。
   * 【需要注意】对于同一笔支付流水系统无法进行处理。
   */
  private String cancelPayRedirectPageURL;
  /**
   * 页面跳转方式
   * 10=公众号
   * 20=小程序
   *
   * ScanPaymentType=10-微信扫码时此字段为必填项，默认为公众号。
   */
  private String scanPageUrlType;
  /**
   * 成功前台跳转页面
   *
   * QRPaymentWay=41时,填入有效此页面只用作商家广告宣传等展示，商户后台应只在收到中金后台的支付成功回调通知后，
   * 才能做真正的支付成功通知处理。
   */
  private String redirectPageURL;
  /**
   * 手机号
   */
  private String o2OPhoneNumber;
  /**
   *
   */
  private String authTxSN;
  /**
   * 贷款期限
   */
  private String loanTerm;
  /**
   * 还款方式:
   *
   * 10=一次性还本付息
   */
  private String repaymentType;
  /**
   * 支付方式:
   *
   * 10=自主支付(暂不支持)
   * 20=受托支付
   */
  @Deprecated
  private String paymentType;
  /**
   * 业务品种
   */
  private String businessCategory;
  /**
   * 合同起始日期
   */
  private String contractStartDate;
  /**
   * 合同终止日期
   */
  private String contractEndDate;
  /**
   * 面客年利率
   */
  private String yearlyInterestRate;
  /**
   * 分账结算域
   */
  private List<SplitItem> splitItemsList;

  @Override
  public void process() throws Exception {
    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    Document document = documentBuilder.newDocument();
    Element Request = document.createElement("Request");
    Element Head = document.createElement("Head");
    Element Body = document.createElement("Body");
    Element TxCode = document.createElement("TxCode");
    Element InstitutionID = document.createElement("InstitutionID");
    Element TxSN = document.createElement("TxSN");
    Element OrderNo = document.createElement("OrderNo");
    Element TerminalUserID = document.createElement("TerminalUserID");
    Element PayerUserID = document.createElement("PayerUserID");
    Element PayeeUserID = document.createElement("PayeeUserID");
    Element PayeeAccountNumber = document.createElement("PayeeAccountNumber");
    Element PaymentWay = document.createElement("PaymentWay");
    Element Amount = document.createElement("Amount");
    Element ExpirePeriod = document.createElement("ExpirePeriod");
    Element PageURL = document.createElement("PageURL");
    Element PlatformName = document.createElement("PlatformName");
    Element GoodsName = document.createElement("GoodsName");
    Element ClientIP = document.createElement("ClientIP");
    Element HasSubsequentSplit = document.createElement("HasSubsequentSplit");
    Element NoticeURL = document.createElement("NoticeURL");
    Element Remark = document.createElement("Remark");
    Element DeductionSettlementFlag = document.createElement("DeductionSettlementFlag");
    Element Extension = document.createElement("Extension");
    Element SMSVerification = document.createElement("SMSVerification");
    Element QuickPay = document.createElement("QuickPay");
    Element BindingTxSN = document.createElement("BindingTxSN");
    Element InstallmentPeriods = document.createElement("InstallmentPeriods");
    Element InterestType = document.createElement("InterestType");
    Element CVN2 = document.createElement("CVN2");
    Element ValidateDate = document.createElement("ValidateDate");
    Element EBankPay = document.createElement("EBankPay");
    Element BankAccountType = document.createElement("BankAccountType");
    Element BankCardType = document.createElement("BankCardType");
    Element BankID = document.createElement("BankID");
    Element Gathering = document.createElement("Gathering");
    Element AccountName = document.createElement("AccountName");
    Element AccountNumber = document.createElement("AccountNumber");
    Element IdentificationType = document.createElement("IdentificationType");
    Element IdentificationNumber = document.createElement("IdentificationNumber");
    Element PhoneNumber = document.createElement("PhoneNumber");
    Element EntrustNo = document.createElement("EntrustNo");
    Element TokenNo = document.createElement("TokenNo");
    Element QRPay = document.createElement("QRPay");
    Element QRPaymentType = document.createElement("QRPaymentType");
    Element QRPaymentWay = document.createElement("QRPaymentWay");
    Element PreTxSN = document.createElement("PreTxSN");
    Element PaymentScene = document.createElement("PaymentScene");
    Element QRPayCode = document.createElement("QRPayCode");
    Element OpenID = document.createElement("OpenID");
    Element MerchantAppID = document.createElement("MerchantAppID");
    Element QRLimitPay = document.createElement("QRLimitPay");
    Element QRPageUrlType = document.createElement("QRPageUrlType");
    Element RedirectPay = document.createElement("RedirectPay");
    Element RedirectSource = document.createElement("RedirectSource");
    Element PayWay = document.createElement("PayWay");
    Element PayType = document.createElement("PayType");
    Element RedirectPayBankID = document.createElement("RedirectPayBankID");
    Element LimitPay = document.createElement("LimitPay");
    Element SubAppID = document.createElement("SubAppID");
    Element SubOpenID = document.createElement("SubOpenID");
    Element InstallmentType = document.createElement("InstallmentType");
    Element FeeMode = document.createElement("FeeMode");
    Element BankAccountNumber = document.createElement("BankAccountNumber");
    Element MaskAccNo = document.createElement("MaskAccNo");
    Element InstallmentForce = document.createElement("InstallmentForce");
    Element LoginState = document.createElement("LoginState");
    Element NumberOfInstallments = document.createElement("NumberOfInstallments");
    Element ScanPay = document.createElement("ScanPay");
    Element ScanPaymentType = document.createElement("ScanPaymentType");
    Element ScanPaymentWay = document.createElement("ScanPaymentWay");
    Element ScanPaymentCode = document.createElement("ScanPaymentCode");
    Element AccountType = document.createElement("AccountType");
    Element IdentityInfo = document.createElement("IdentityInfo");
    Element TerminalID = document.createElement("TerminalID");
    Element ScanPaymentLimitFlag = document.createElement("ScanPaymentLimitFlag");
    Element CancelPayRedirectPageURL = document.createElement("CancelPayRedirectPageURL");
    Element ScanPageUrlType = document.createElement("ScanPageUrlType");
    Element RedirectPageURL = document.createElement("RedirectPageURL");
    Element O2OPay = document.createElement("O2OPay");
    Element O2OPhoneNumber = document.createElement("O2OPhoneNumber");
    Element AuthPay = document.createElement("AuthPay");
    Element AuthTxSN = document.createElement("AuthTxSN");
    Element CreditPay = document.createElement("CreditPay");
    Element LoanTerm = document.createElement("LoanTerm");
    Element RepaymentType = document.createElement("RepaymentType");
    Element PaymentType = document.createElement("PaymentType");
    Element BusinessCategory = document.createElement("BusinessCategory");
    Element ContractStartDate = document.createElement("ContractStartDate");
    Element ContractEndDate = document.createElement("ContractEndDate");
    Element YearlyInterestRate = document.createElement("YearlyInterestRate");
    Request.setAttribute("version", "2.1");
    document.appendChild(Request);
    Request.appendChild(Head);
    Head.appendChild(TxCode);
    TxCode.setTextContent(this.txCode);
    Request.appendChild(Body);
    Body.appendChild(InstitutionID);
    InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
    Body.appendChild(TxSN);
    TxSN.setTextContent(this.txSN);
    Body.appendChild(OrderNo);
    OrderNo.setTextContent(this.orderNo);
    Body.appendChild(TerminalUserID);
    TerminalUserID.setTextContent(this.terminalUserID);
    Body.appendChild(PayerUserID);
    PayerUserID.setTextContent(this.payerUserID);
    Body.appendChild(PayeeUserID);
    PayeeUserID.setTextContent(this.payeeUserID);
    Body.appendChild(PayeeAccountNumber);
    PayeeAccountNumber.setTextContent(this.payeeAccountNumber);
    Body.appendChild(PaymentWay);
    PaymentWay.setTextContent(String.valueOf(this.paymentWay));
    Body.appendChild(Amount);
    Amount.setTextContent(this.amount);
    Body.appendChild(ExpirePeriod);
    ExpirePeriod.setTextContent(this.expirePeriod);
    Body.appendChild(PageURL);
    PageURL.setTextContent(this.pageURL);
    Body.appendChild(GoodsName);
    GoodsName.setTextContent(this.goodsName);
    Body.appendChild(PlatformName);
    PlatformName.setTextContent(this.platformName);
    Body.appendChild(ClientIP);
    ClientIP.setTextContent(this.clientIP);
    Body.appendChild(HasSubsequentSplit);
    HasSubsequentSplit.setTextContent(this.hasSubsequentSplit);
    Body.appendChild(NoticeURL);
    NoticeURL.setTextContent(this.noticeURL);
    Body.appendChild(Remark);
    Remark.setTextContent(this.remark);
    Body.appendChild(DeductionSettlementFlag);
    DeductionSettlementFlag.setTextContent(this.deductionSettlementFlag);
    Body.appendChild(Extension);
    Extension.setTextContent(this.extension);
    if (this.paymentWay.equals("10")) {
      Body.appendChild(QuickPay);
      QuickPay.appendChild(SMSVerification);
      SMSVerification.setTextContent(this.sMSVerification);
      QuickPay.appendChild(BindingTxSN);
      BindingTxSN.setTextContent(this.bindingTxSN);
      QuickPay.appendChild(InstallmentPeriods);
      InstallmentPeriods.setTextContent(this.installmentPeriods);
      QuickPay.appendChild(InterestType);
      InterestType.setTextContent(this.interestType);
      QuickPay.appendChild(CVN2);
      CVN2.setTextContent(this.cVN2);
      QuickPay.appendChild(ValidateDate);
      ValidateDate.setTextContent(this.validateDate);
    } else if (this.paymentWay.equals("20")) {
      Body.appendChild(EBankPay);
      EBankPay.appendChild(BankAccountType);
      BankAccountType.setTextContent(this.bankAccountType);
      EBankPay.appendChild(BankCardType);
      BankCardType.setTextContent(this.bankCardType);
      EBankPay.appendChild(BankID);
      BankID.setTextContent(this.bankID);
    } else if (this.paymentWay.equals("30")) {
      Body.appendChild(Gathering);
      Gathering.appendChild(BankAccountType);
      BankAccountType.setTextContent(this.bankAccountType);
      Gathering.appendChild(BankCardType);
      BankCardType.setTextContent(this.bankCardType);
      Gathering.appendChild(BankID);
      BankID.setTextContent(this.bankID);
      Gathering.appendChild(AccountName);
      AccountName.setTextContent(this.accountName);
      Gathering.appendChild(AccountNumber);
      AccountNumber.setTextContent(this.accountNumber);
      Gathering.appendChild(IdentificationType);
      IdentificationType.setTextContent(this.identificationType);
      Gathering.appendChild(IdentificationNumber);
      IdentificationNumber.setTextContent(this.identificationNumber);
      Gathering.appendChild(PhoneNumber);
      PhoneNumber.setTextContent(this.phoneNumber);
      Gathering.appendChild(EntrustNo);
      EntrustNo.setTextContent(this.entrustNo);
      Gathering.appendChild(TokenNo);
      TokenNo.setTextContent(this.tokenNo);
    } else if (this.paymentWay.equals("40")) {
      Body.appendChild(QRPay);
      QRPay.appendChild(QRPaymentType);
      QRPaymentType.setTextContent(this.qRPaymentType);
      QRPay.appendChild(QRPaymentWay);
      QRPaymentWay.setTextContent(this.qRPaymentWay);
      QRPay.appendChild(PreTxSN);
      PreTxSN.setTextContent(this.preTxSN);
      QRPay.appendChild(PaymentScene);
      PaymentScene.setTextContent(this.paymentScene);
      QRPay.appendChild(QRPayCode);
      QRPayCode.setTextContent(this.qRPayCode);
      QRPay.appendChild(OpenID);
      OpenID.setTextContent(this.openID);
      QRPay.appendChild(MerchantAppID);
      MerchantAppID.setTextContent(this.merchantAppID);
      QRPay.appendChild(QRLimitPay);
      QRLimitPay.setTextContent(this.qRLimitPay);
      QRPay.appendChild(CancelPayRedirectPageURL);
      CancelPayRedirectPageURL.setTextContent(this.cancelPayRedirectPageURL);
      QRPay.appendChild(QRPageUrlType);
      QRPageUrlType.setTextContent(this.qRPageUrlType);
      QRPay.appendChild(RedirectPageURL);
      RedirectPageURL.setTextContent(this.redirectPageURL);
    } else if (this.paymentWay.equals("80")) {
      Body.appendChild(RedirectPay);
      RedirectPay.appendChild(RedirectSource);
      RedirectSource.setTextContent(this.redirectSource);
      RedirectPay.appendChild(PayWay);
      PayWay.setTextContent(this.payWay);
      RedirectPay.appendChild(PayType);
      PayType.setTextContent(this.payType);
      RedirectPay.appendChild(RedirectPayBankID);
      RedirectPayBankID.setTextContent(this.redirectPayBankID);
      RedirectPay.appendChild(LimitPay);
      LimitPay.setTextContent(this.limitPay);
      RedirectPay.appendChild(SubAppID);
      SubAppID.setTextContent(this.subAppID);
      RedirectPay.appendChild(SubOpenID);
      SubOpenID.setTextContent(this.subOpenID);
      RedirectPay.appendChild(InstallmentType);
      InstallmentType.setTextContent(this.installmentType);
      RedirectPay.appendChild(FeeMode);
      FeeMode.setTextContent(this.feeMode);
      RedirectPay.appendChild(BankAccountNumber);
      BankAccountNumber.setTextContent(this.bankAccountNumber);
      RedirectPay.appendChild(MaskAccNo);
      MaskAccNo.setTextContent(this.maskAccNo);
      RedirectPay.appendChild(InstallmentForce);
      InstallmentForce.setTextContent(this.installmentForce);
      RedirectPay.appendChild(LoginState);
      LoginState.setTextContent(this.loginState);
      RedirectPay.appendChild(NumberOfInstallments);
      NumberOfInstallments.setTextContent(this.numberOfInstallments);
    } else if (this.paymentWay.equals("42")) {
      Body.appendChild(ScanPay);
      ScanPay.appendChild(ScanPaymentType);
      ScanPaymentType.setTextContent(this.scanPaymentType);
      ScanPay.appendChild(ScanPaymentWay);
      ScanPaymentWay.setTextContent(this.scanPaymentWay);
      ScanPay.appendChild(PreTxSN);
      PreTxSN.setTextContent(this.preTxSN);
      ScanPay.appendChild(PaymentScene);
      PaymentScene.setTextContent(this.paymentScene);
      ScanPay.appendChild(ScanPaymentCode);
      ScanPaymentCode.setTextContent(this.scanPaymentCode);
      ScanPay.appendChild(AccountType);
      AccountType.setTextContent(this.accountType);
      ScanPay.appendChild(IdentityInfo);
      IdentityInfo.setTextContent(this.identityInfo);
      ScanPay.appendChild(TerminalID);
      TerminalID.setTextContent(this.terminalID);
      ScanPay.appendChild(ScanPaymentLimitFlag);
      ScanPaymentLimitFlag.setTextContent(this.scanPaymentLimitFlag);
      ScanPay.appendChild(CancelPayRedirectPageURL);
      CancelPayRedirectPageURL.setTextContent(this.cancelPayRedirectPageURL);
      ScanPay.appendChild(ScanPageUrlType);
      ScanPageUrlType.setTextContent(this.scanPageUrlType);
      ScanPay.appendChild(RedirectPageURL);
      RedirectPageURL.setTextContent(this.redirectPageURL);
      ScanPay.appendChild(InstallmentType);
      InstallmentType.setTextContent(this.installmentType);
      ScanPay.appendChild(FeeMode);
      FeeMode.setTextContent(this.feeMode);
      ScanPay.appendChild(NumberOfInstallments);
      NumberOfInstallments.setTextContent(this.numberOfInstallments);
      ScanPay.appendChild(SubAppID);
      SubAppID.setTextContent(this.subAppID);
    } else if (this.paymentWay.equals("50")) {
      Body.appendChild(O2OPay);
      O2OPay.appendChild(O2OPhoneNumber);
      O2OPhoneNumber.setTextContent(this.o2OPhoneNumber);
    } else if (this.paymentWay.equals("43")) {
      Body.appendChild(AuthPay);
      AuthPay.appendChild(AuthTxSN);
      AuthTxSN.setTextContent(this.authTxSN);
    } else if (this.paymentWay.equals("02")) {
      Body.appendChild(CreditPay);
      CreditPay.appendChild(LoanTerm);
      LoanTerm.setTextContent(this.loanTerm);
      CreditPay.appendChild(RepaymentType);
      RepaymentType.setTextContent(this.repaymentType);
      CreditPay.appendChild(PaymentType);
      PaymentType.setTextContent(this.paymentType);
      CreditPay.appendChild(BusinessCategory);
      BusinessCategory.setTextContent(this.businessCategory);
      CreditPay.appendChild(ContractStartDate);
      ContractStartDate.setTextContent(this.contractStartDate);
      CreditPay.appendChild(ContractEndDate);
      ContractEndDate.setTextContent(this.contractEndDate);
      CreditPay.appendChild(YearlyInterestRate);
      YearlyInterestRate.setTextContent(this.yearlyInterestRate);
    }
    if (this.splitItemsList != null && this.splitItemsList.size() > 0)
      for (int i = 0; i < this.splitItemsList.size(); i++) {
        SplitItem splitItem = this.splitItemsList.get(i);
        Element SplitItems = document.createElement("SplitItems");
        Element SplitTxSN = document.createElement("SplitTxSN");
        Element SplitUserID = document.createElement("SplitUserID");
        Element SplitAccountNumber = document.createElement("SplitAccountNumber");
        Element SplitBindingTxSN = document.createElement("SplitBindingTxSN");
        Element SplitBankAccountType = document.createElement("SplitBankAccountType");
        Element SplitBankID = document.createElement("SplitBankID");
        Element SplitBankAccountName = document.createElement("SplitBankAccountName");
        Element SplitBankAccountNumber = document.createElement("SplitBankAccountNumber");
        Element SplitAmount = document.createElement("SplitAmount");
        Element SplitFrozenAmount = document.createElement("SplitFrozenAmount");
        Element CNAPSCode = document.createElement("CNAPSCode");
        Element Note = document.createElement("Note");
        Body.appendChild(SplitItems);
        SplitItems.appendChild(SplitTxSN);
        SplitTxSN.setTextContent(splitItem.getSplitTxSN());
        SplitItems.appendChild(SplitUserID);
        SplitUserID.setTextContent(splitItem.getSplitUserID());
        SplitItems.appendChild(SplitAccountNumber);
        SplitAccountNumber.setTextContent(splitItem.getSplitAccountNumber());
        SplitItems.appendChild(SplitBindingTxSN);
        SplitBindingTxSN.setTextContent(splitItem.getSplitBindingTxSN());
        SplitItems.appendChild(SplitBankAccountType);
        SplitBankAccountType.setTextContent(splitItem.getSplitBankAccountType());
        SplitItems.appendChild(SplitBankID);
        SplitBankID.setTextContent(splitItem.getSplitBankID());
        SplitItems.appendChild(SplitBankAccountName);
        SplitBankAccountName.setTextContent(splitItem.getSplitBankAccountName());
        SplitItems.appendChild(SplitBankAccountNumber);
        SplitBankAccountNumber.setTextContent(splitItem.getSplitBankAccountNumber());
        SplitItems.appendChild(SplitAmount);
        SplitAmount.setTextContent(String.valueOf(splitItem.getSplitAmount()));
        SplitItems.appendChild(SplitFrozenAmount);
        SplitFrozenAmount.setTextContent(splitItem.getSplitFrozenAmount());
        SplitItems.appendChild(CNAPSCode);
        CNAPSCode.setTextContent(splitItem.getCNAPSCode());
        SplitItems.appendChild(Note);
        Note.setTextContent(splitItem.getNote());
      }
    postProcess(document);
  }
}
