package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseRequest;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.validation.constraints.NotBlank;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

/**
 * 4656-充值/提现/代付查询
 *
 * @author Keller
 */
@Getter
@Setter
@ToString
public class Tx4656Request extends TxBaseRequest {
  /**
   * 原交易流水号
   */
  @NotBlank(message = "原交易流水号不能为空")
  private String sourceTxSN;
  /**
   * 原业务交易编码:
   *
   * 4641=充值
   * 4643=提现
   * 4645=代付
   * 4651=转账充值
   */
  @NotBlank(message = "原业务交易编码不能为空")
  private String sourceTxCode;

  @Override
  public void process() throws Exception {
    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    Document document = documentBuilder.newDocument();
    Element Request = document.createElement("Request");
    Element Head = document.createElement("Head");
    Element Body = document.createElement("Body");
    Element TxCode = document.createElement("TxCode");
    Element InstitutionID = document.createElement("InstitutionID");
    Element SourceTxSN = document.createElement("SourceTxSN");
    Element SourceTxCode = document.createElement("SourceTxCode");
    document.appendChild(Request);
    Request.setAttribute("version", "2.1");
    Request.appendChild(Head);
    Head.appendChild(TxCode);
    TxCode.setTextContent(this.txCode);
    Request.appendChild(Body);
    Body.appendChild(InstitutionID);
    InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
    Body.appendChild(SourceTxSN);
    SourceTxSN.setTextContent(this.sourceTxSN);
    Body.appendChild(SourceTxCode);
    SourceTxCode.setTextContent(this.sourceTxCode);
    postProcess(document);
  }

}
