package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.remote.internal;

import com.biz.crm.common.pay.support.cpcn.base.common.http.HttpData;
import com.biz.crm.common.pay.support.cpcn.base.common.http.NameValuePair;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnNoticeType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.configuration.CpcnProperties;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.remote.RemoteStrategy;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.vo.NoticeInfo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;

/**
 * 5018-支付通知
 * <pre>
 *   机构系统通过该接口可以对 5011-支付(API)和 5012-支付(页面)交易进行查询，
 *   支付平台返回该笔支付交易的支付状态、支付方式、支付成功时间等信息。
 * </pre>
 * @author dy
 * @date 2022/06/28
 */
@Slf4j
@Component
public class Remote5018Strategy implements RemoteStrategy {

  @Autowired
  private CpcnProperties cpcnProperties;
  @Autowired
  private CloseableHttpClient client;

  @Override
  public String getCode() {
    return CpcnNoticeType.NOTICE_5018.getCode();
  }

  @Override
  @Async("defaultRemoteNoticeExecutor")
  public void handler(NoticeInfo info) {
    if (ArrayUtils.isNotEmpty(cpcnProperties.getRemoteUrl())) {
      NameValuePair message = new NameValuePair("message", info.getMessage());
      NameValuePair signature = new NameValuePair("signature", info.getSignature());
      List<NameValuePair> params = Lists.newArrayList(message, signature);
      String[] urls = cpcnProperties.getRemoteUrl();
      for (String remoteUrl : urls) {
        try {
          String response = execute(remoteUrl, params);
          log.info("调用应用接口 :'{}',返回结果为:'{}'", remoteUrl, response);
        } catch (Exception e) {
          log.error(e.getMessage(), e);
          continue;
        }
      }
    } else {
      log.info("未配置转发地址，4658响应请求未转发");
    }
  }

  /**
   * 执行回调信息通知
   *
   * @param uri
   * @param list
   * @return
   */
  private String execute(String uri, List<NameValuePair> list) {
    HttpData httpData = new HttpData(list, "UTF-8");
    String request = httpData.getData();
    HttpPost httpPost = new HttpPost(uri);
    BasicHeader basicHeader = new BasicHeader("Content-Type", "application/x-www-form-urlencoded");
    httpPost.addHeader(basicHeader);
    String response = null;
    HttpEntity httpEntity = null;
    try {
      StringEntity stringEntity = new StringEntity(request, Charset.forName("UTF-8"));
      httpPost.setEntity(stringEntity);
      CloseableHttpResponse closeableHttpResponse = client.execute(httpPost);
      httpEntity = closeableHttpResponse.getEntity();
      Validate.notNull(httpEntity, "httpclient请求返回为空，请检查请求地址！");
      response = EntityUtils.toString(httpEntity, Charset.forName("UTF-8"));
    } catch (IOException e) {
      log.error("httpclient 请求错误", e);
      throw new RuntimeException(e);
    }
    return response;
  }
}
